#!/usr/bin/env python
import smtplib,json,imaplib,configdata
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.MIMEBase import MIMEBase
from email import Encoders
from mysql import mysql

class kirimemail(object):
    def __init__(self):
        self._dbmysl=mysql()
        self._datacof=self._dbmysl.loadAssoc("select setting from tb_setting where id=11", [])
        
        self.smtphost= ''
        self.smtpport= 0
        self.smptuser= ''
        self.smtppass= ''
        
        self._arrjs={}
        if "setting" in self._datacof:
            self._arrjs=json.loads(self._datacof['setting'])
        
        if "host" in self._arrjs: self.smtphost= self._arrjs['host']
        if "email" in self._arrjs: self.smptuser= self._arrjs['email']
        if "password" in self._arrjs: self.smtppass= self._arrjs['password']
        if "port" in self._arrjs: self.smtpport= int(self._arrjs['port'])
        self._dbmysl.closedb()
        
    def kiripesan(self,email,subj,pesan):
        
        try:
            msg = MIMEMultipart()
            msg["Subject"] = subj
            msg["From"] = self.smptuser
            msg["To"] = email
            
            msg.attach(MIMEText(pesan, 'html'))
            
            smtpObj = smtplib.SMTP_SSL(self.smtphost, self.smtpport)
            smtpObj.set_debuglevel(1)
            smtpObj.ehlo()
            #smtpObj.starttls()
            smtpObj.login(self.smptuser, self.smtppass)
            
            print "Ok"
            smtpObj.sendmail(self.smptuser, [email], msg.as_string())         
            smtpObj.close()    
            print "Successfully sent email"
            return True
        except Exception as err :  
            print "Error %s " % err
            return False
    
    def kirimpesan(self,dataps,datadok):
        email=dataps['email']
        pesan=dataps['pesan']
        subj=dataps['subject']
        try:
            msg = MIMEMultipart()
            msg["Subject"] = subj
            msg["From"] = self.smptuser
            msg["To"] = email
            
            msg.attach(MIMEText(pesan, 'html'))
            if len(datadok)>0:
                for i in range(len(datadok)):
                    part = MIMEBase('application', "octet-stream")
                    part.set_payload(open(configdata.LSP_CONFIG['HOMEDIR']+"public_html/"+datadok[i]['folder']+datadok[i]['nama_baru'], "rb").read())
                    Encoders.encode_base64(part)
                        
                    part.add_header('Content-Disposition', 'attachment; filename="'+datadok[i]['nama_awal']+'"')
                    
                    msg.attach(part)

            smtpObj = smtplib.SMTP_SSL(self.smtphost, self.smtpport)
            smtpObj.set_debuglevel(1)
            smtpObj.ehlo()
            #smtpObj.starttls()
            smtpObj.login(self.smptuser, self.smtppass)
            
            print "Ok"
            smtpObj.sendmail(self.smptuser, [email], msg.as_string())         
            smtpObj.close()    
            print "Successfully sent email"
            return True
        except Exception as err :  
            print "Error %s " % err
            return False