<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");

header("Content-type: application/json");
if(isset($_POST['ikdata'])){
if (!isset($_SESSION)) session_start();
$db=pDatabase::getInstance();
$datafungsi=[
	"getTabel"=>"getTabel",
	"datacari01"=>"datacari01",
	"simpanusermanajemen"=>"simpanusermanajemen",
	"editusermanajemen"=>"editusermanajemen",
	"hapusData"=>"hapusData",
	"status"=>"status",
];

if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data,$cl);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$db=pDatabase::getInstance();
	$query="select * from tb_level order by id asc";
	$rs=$db->getObj($query);
	$datalevel=array();
	foreach ($rs as $obj) {
		$datalevel[$obj->nama]=$obj->nama;
	}
	
	$datastatus=array("Aktif"=>1,"Tidak Aktif"=>0);
	
	$kunci=array("username","nama","level","status");
	$alias=array("Username","Nama User","Level","Status");
	$kolom=array("t1.username","t1.nama","t2.nama","t1.status");
	$jenis=array("level"=>array("jenis"=>"dropdown","data"=>$datalevel),
				"status"=>array("jenis"=>"dropdown","data"=>$datastatus));
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.username LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$wh.="and t1.level<= ? ";
	array_push($datapush,$_SESSION['profile']['level']);
	
	$qt="SELECT COUNT(*) as total FROM tb_username as t1 
		inner join tb_level as t2 on t1.level=t2.id
		left join tb_pegawai as t3 on t1.idpegawai=t3.id
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	
	$query="SELECT t1.id,t1.username,t1.nama,t1.status,
			t1.level,IF(t2.nama IS NULL,'NONE',t2.nama) as namalevel,
			t1.idpegawai,
			t2.pegawai,
			if(t3.nama is null,'',t3.nama) as namapegawai,
			$total as halaman FROM tb_username as t1
		inner join tb_level as t2 on t1.level=t2.id
		left join tb_pegawai as t3 on t1.idpegawai=t3.id
		WHERE t1.id>0 ".$wh."
		ORDER BY t1.level DESC,t1.nama ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	return $rs;
}


function simpanusermanajemen($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$query="select * from tb_level where id=? ";
	$rslevel=$db->loadAssoc($query,array($data['level']));
	if(!isset($rslevel['id'])){
		$hasil['pesan']=[["pesan"=>"Data level tidak ditemukan"]];
		return json_encode($hasil,true);
	}
	
	if($rslevel['pegawai']==1){
		$query="select * from tb_pegawai where id=? ";
		$rsp=$db->loadAssoc($query,array($data['idpegawai']));
		if(!isset($rsp['id'])){
			$hasil['pesan']=[["pesan"=>"Data pegawai tidak ditemukan"]];
			return json_encode($hasil,true);
		}
	}
	$pass=$db->genPassword(sha1($data['pass']));
	$datain=array(
		"username"=>$data['user'],
		"password"=>$pass,
		"level"=>$data['level'],
		"nama"=>$data['nama'],
		"status"=>1,
	);
	
	if($rslevel['pegawai']==1){
		$datain['idpegawai']=$data['idpegawai'];
	}
	
	$rs=$db->insert("tb_username",$datain);
	if($rs==1){
		$hasil['status']=1;
	}
	return json_encode($hasil,true);
}
function editusermanajemen($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$query="select * from tb_level where id=? ";
	$rslevel=$db->loadAssoc($query,array($data['level']));
	if(!isset($rslevel['id'])){
		$hasil['pesan']=[["pesan"=>"Data level tidak ditemukan"]];
		return json_encode($hasil,true);
	}
	
	if($rslevel['pegawai']==1){
		$query="select * from tb_pegawai where id=? ";
		$rsp=$db->loadAssoc($query,array($data['idpegawai']));
		if(!isset($rsp['id'])){
			$hasil['pesan']=[["pesan"=>"Data pegawai tidak ditemukan"]];
			return json_encode($hasil,true);
		}
	}
	
	$datain=array(
		"level"=>$data['level'],
		"nama"=>$data['nama'],
		"status"=>1,
	);
	if($rslevel['pegawai']==1){
		$datain['idpegawai']=$data['idpegawai'];
	}
	
	if($data['ubahpass']==1){
		$pass=$db->genPassword(sha1($data['pass']));
		$datain['username']=$data['user'];
		$datain['password']=$pass;
	}
	$rs=$db->update("tb_username",$datain,"id",$data['id']);
	if($rs==1){
		$hasil['status']=1;
	}
	return json_encode($hasil,true);
}

function hapusData($data){
	$db=pDatabase::getInstance();
	if($_SESSION['profile']['id']==$data['id']){
		return 2;
	}
	$wh="";
	$datapush=array($data['id']);
	if($_SESSION['profile']['level']<100){
		$wh.="and level<? ";
		array_push($datapush,$_SESSION['profile']['level']);
	}
	$query="DELETE FROM tb_username WHERE id=? ".$wh;
	$rs=$db->query($query,$datapush);
	return true;
}

function status($data){
	$db=pDatabase::getInstance();
	if($data['id']==$_SESSION['profile']['id']) return 2;
	
	$wh="";
	$datapush=array($data['status'],$data['id']);
	
	if($_SESSION['profile']['level']<100){
		$wh.="and level<? ";
		array_push($datapush,$_SESSION['profile']['level']);
	}
	$query="update tb_username set status=? where id=? ".$wh;
	$rs=$db->query($query,$datapush);
	return $rs;
}

?>