<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getjenissurat"=>"getjenissurat",
		"getTabel"=>"getTabel",
		"inputsuratkeluar"=>"inputsuratkeluar",
		"editsuratkeluar"=>"editsuratkeluar",
		"hapusData"=>"hapusData",
		"getcatatansurat"=>"getcatatansurat",
		"getdokumensurat"=>"getdokumensurat",
		"getdatadisposisi"=>"getdatadisposisi",
		"getdatajabatanstr"=>"getdatajabatanstr",
		"getjabatanfung"=>"getjabatanfung",
		"getdatasuratbalasan"=>"getdatasuratbalasan",
		"getdataCatatan"=>"getdataCatatan"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("tujuan","alamattujuan");
	$alias=array("Tujuan","Alamat Tujuan");
	$kolom=array("t1.tujuan","t1.alamat_tujuan");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.tujuan LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$qt="SELECT COUNT(*) as total FROM tb_surat_keluar as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_kategorisurat as t3 on t1.idkategori=t3.id
		inner join tb_master_jenissurat as t4 on t1.idjenissurat=t4.id
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	array_unshift($datapush,$_SESSION['profile']['level'],$_SESSION['profile']['level']);
	
	$query="SELECT t1.`id`,
			t1.`tanggal_input`,
			t1.`tanggal_surat`,
			t1.`idkategori`,
			t1.`idjenissurat`,
			t1.`idkategorijenissurat`,
			t1.`idsurat`,
			t1.`iduser`,
			t1.`nomor`,
			t1.`keperluan`,
			t1.`tujuan`,
			t1.`alamat_tujuan`,
			t1.`keterangan`,
			t1.`jumlah_dokumen`,
			t1.`status`,
			t2.jumlah_catatan,
			a1.nama as namastatus,
			a1.bg,a1.warna,
			if(b1.id is null,0,1) as edit,
			if(b2.id is null,0,1) as hapus,
			$total as halaman FROM tb_surat_keluar as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_kategorisurat as t3 on t1.idkategori=t3.id
		inner join tb_master_jenissurat as t4 on t1.idjenissurat=t4.id
		inner join tb_master_status as a1 on t2.status=a1.id
		left join tb_master_status_level as b1 on t2.status=b1.idstatus and b1.mode=0 and b1.idlevel=?
		left join tb_master_status_level as b2 on t2.status=b2.idstatus and b2.mode=1 and b2.idlevel=?
		WHERE t1.id>0 ".$wh."
		GROUP BY t1.id
		ORDER BY t1.tanggal_surat ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	
	return $rs;
}

function getjenissurat($data){
	$db=pDatabase::getInstance();
	$query="select * from tb_master_jenissurat where idkategori=? and in_out=2";
	$rs=$db->loadAll($query,array($data['idkategori']));
	
	ob_start();
	foreach ($rs as $obj) {
		?>
		<option value="<?php echo $obj['id'];?>"><?php echo $obj['nama'];?></option>
		<?php
	}
	$datahtm=ob_get_clean();
	$hasil=array("data"=>$rs,"html"=>$datahtm);
	return json_encode($hasil,true);
}

function inputsuratkeluar($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$statuspengajuan=50;
	if($data['submitdata']==1) $statuspengajuan=51;
	
	$idkategorisurat=$data['idkategori'];
	$idjenissurat=$data['idjenissurat'];
	$idkategorijenis=$data['idkategorijenis'];
	$nomorsuratpanjang=$data['nomor'];
	$balasan=0;
	if(isset($data['balasan'])) $balasan=$data['balasan'];
	$idsuratbalasan=0;
	if($balasan==1) $idsuratbalasan=$data['idsuratbalasan'];
	
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$tanggalsurat=$db->d_date($data['tanggalsurat']);
	$tahun=date('Y',strtotime($tanggalsurat));
	$bulan=date('m',strtotime($tanggalsurat));
	
	$tanggalterima=$db->d_date($data['tanggalterima']);
	
	$datajs=array(
		"datadokumen"=>json_encode($data['datadokumen']),
		"idkategori"=>$idkategorisurat,
		"idjenissurat"=>$idjenissurat,
		"idkategorijenissurat"=>$idkategorijenis,
		"nomor"=>$data['nomor'],
		"tanggalsurat"=>$data['tanggalsurat'],
		"tujuan"=>$data['tujuan'],
		"alamattujuan"=>$data['alamattujuan'],
		"balasan"=>$balasan,
		"idsuratbalasan"=>$idsuratbalasan,
		"keperluan"=>$data['keperluan'],
		"tujuan"=>$data['tujuan'],
		"keterangan"=>$data['keterangan']
	);
	$datasr=array(
		"tanggal_surat"=>$tanggalsurat,
		"idpegawai"=>0,
		"nomor_panjang"=>$nomorsuratpanjang,
		"tahun"=>$tahun,
		"bulan"=>$bulan,
		"iduser"=>$_SESSION['profile']['id'],
		"idkategori"=>$idkategorisurat,
		"idjenissurat"=>$idjenissurat,
		"idkategorijenis"=>$idkategorijenis,
		"idbalasan"=>$idsuratbalasan,
		"datasurat"=>json_encode($datajs,true),
		"status"=>$statuspengajuan
	);
	
	$rss=$db->insert("tb_suratbdk",$datasr,1);
	if($rss<=0){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal input data surat"]);
	}
	
	$idsurat=$rss;
	$datadisposisi=$data['datadisposisi'];
	
	if(sizeof($datadisposisi)>0){
		foreach ($datadisposisi as $datadis) {
			$arrdis=$datadis;
			foreach ($arrdis as $obdis) {
				
				$datain=array(
					"idsurat"=>$idsurat,
					"nomorgroup"=>$obdis['nomorgroup'],
					"urutan"=>$obdis['urutan'],
					"nama"=>$obdis['nama']
				);
				
				$rsdis=$db->insert("tb_suratbdk_disposisi_manual",$datain,1);
				if($rsdis<=0){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data disposisi surat"]);
				}
				$iddisposisimanual=$rsdis;
				$datajabatan=$obdis['datajabatan'];
				foreach ($datajabatan as $objab) {
					$datajab=array(
						"idsurat"=>$idsurat,
						"iddisposisimanual"=>$iddisposisimanual,
						"modejabatan"=>$objab['modejabatan'],
						"idjabatan"=>$objab['idjabatan'],
						"view"=>$objab['view'],
						"edit"=>$objab['edit'],
						"hapus"=>$objab['hapus']
					);
					
					$rsinjab=$db->insert("tb_suratbdk_disposisi_manual_jabatan",$datajab,1);
					if($rsinjab<=0){
						$statusin=false;
						array_push($dataerr,["pesan"=>"Gagal input data jabatan (".$objab['idjabatan'].") disposisi surat"]);
					}
					$iddisposisijabatan=$rsinjab;
					$datastatus=$objab['datastatus'];
					foreach ($datastatus as $obst) {
						$datainst=array(
							"iddisposisimanualjabatan"=>$iddisposisijabatan,
							"idstatus"=>$obst['idstatus']
						);
						
						$rsinst=$db->insert("tb_suratbdk_disposisi_manual_idstatus",$datainst);
						if($rsinst!=1) {
							$statusin=false;
							array_push($dataerr,["pesan"=>"Gagal input data akses status jabatan (".$objab['idjabatan'].") ID status ".$obst['idstatus']]);
						}
					}
				}
			}
			
		}
	}
	
	
	if($statusin){
		$datain=[
			"tanggal_surat"=>$tanggalsurat,
			"idkategori"=>$idkategorisurat,
			"idjenissurat"=>$idjenissurat,
			"idkategorijenissurat"=>$idkategorijenis,
			"idsurat"=>$idsurat,
			"iduser"=>$_SESSION['profile']['id'],
			"nomor"=>$nomorsuratpanjang,
			"tujuan"=>$data['tujuan'],
			"alamat_tujuan"=>$data['alamattujuan'],
			"keperluan"=>$data['keperluan'],
			"balasan"=>$balasan,
			"idsuratbalasan"=>$idsuratbalasan,
			"keterangan"=>$data['keterangan'],
			"status"=>$statuspengajuan
		];
		$rs=$db->insert("tb_surat_keluar",$datain,1);
		if($rs<=0) {
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal input data surat keluar"]);
		}
		$idsuratkeluar=$rs;
		if($statusin){
			$datadokumen=$data['datadokumen'];
			foreach ($datadokumen as $obp) {
				$datain=array(
					"idsuratkeluar"=>$idsuratkeluar,
					"iddokumen"=>$obp['iddokumen'],
					"nama"=>$obp['nama'],
				);
				
				$rsp=$db->insert("tb_surat_keluar_dokumen",$datain);
				if($rsp!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data dokumen surat keluar ".$obp['nama']]);
				}
				
				$datainsr=array(
					"idsurat"=>$idsurat,
					"iddokumen"=>$obp['iddokumen'],
					"nama"=>$obp['nama'],
				);
				
				$rsds=$db->insert("tb_suratbdk_dokumen",$datainsr);
				if($rsds!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data dokumen surat ".$obp['nama']]);
				}
			}
		}
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
		if($data['submitdata']==1){
			$datahasil=$db->setdatadisposisiawal($idsurat);
			if(isset($datahasil['status'])){
				if($datahasil['status']!=1) {
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal set disposisi surat"]);
				}
			}
		}
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function editsuratkeluar($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$wh="";
	$datapush=array($_SESSION['profile']['level'],$data['id']);
	$query="select t1.id,t1.idsurat,
			t1.status,
			t2.tanggal_surat,
			t2.nomor_panjang
			from tb_surat_keluar as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_status_level as t3 on t2.status=t3.idstatus
		where t3.mode=0 and t3.idlevel=? and t1.id=? ".$wh;
	$rsc=$db->loadAssoc($query,$datapush);
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$statuspengajuan=$rsc['status'];
	if($data['submitdata']==1) $statuspengajuan=51;
	
	
	$idkategorisurat=$data['idkategori'];
	$idjenissurat=$data['idjenissurat'];
	$idkategorijenis=$data['idkategorijenis'];
	$nomorsuratpanjang=$data['nomor'];
	$idsurat=$rsc['idsurat'];
	$balasan=0;
	if(isset($data['balasan'])) $balasan=$data['balasan'];
	$idsuratbalasan=0;
	if($balasan==1) $idsuratbalasan=$data['idsuratbalasan'];
	
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$tanggalsurat=$db->d_date($data['tanggalsurat']);
	$tahun=date('Y',strtotime($tanggalsurat));
	$bulan=date('m',strtotime($tanggalsurat));
	
	$tanggalterima=$db->d_date($data['tanggalterima']);
	
	$datajs=array(
		"datadokumen"=>json_encode($data['datadokumen']),
		"idkategori"=>$idkategorisurat,
		"idjenissurat"=>$idjenissurat,
		"idkategorijenissurat"=>$idkategorijenis,
		"nomor"=>$data['nomor'],
		"tanggalsurat"=>$data['tanggalsurat'],
		"tujuan"=>$data['tujuan'],
		"alamattujuan"=>$data['alamattujuan'],
		"balasan"=>$balasan,
		"idsuratbalasan"=>$idsuratbalasan,
		"keperluan"=>$data['keperluan'],
		"tujuan"=>$data['tujuan'],
		"keterangan"=>$data['keterangan']
	);
	$datasr=array(
		"tanggal_surat"=>$tanggalsurat,
		"idpegawai"=>0,
		"nomor_panjang"=>$nomorsuratpanjang,
		"tahun"=>$tahun,
		"bulan"=>$bulan,
		"iduser"=>$_SESSION['profile']['id'],
		"idkategori"=>$idkategorisurat,
		"idjenissurat"=>$idjenissurat,
		"idkategorijenis"=>$idkategorijenis,
		"idbalasan"=>$idsuratbalasan,
		"datasurat"=>json_encode($datajs,true),
		"status"=>$statuspengajuan
	);
	
	$rss=$db->update("tb_suratbdk",$datasr,"id",$idsurat);
	if($rss!=1){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal update data surat"]);
	}
	
	$query="delete from tb_suratbdk_disposisi_manual where idsurat=? ";
	$rsd=$db->query($query,array($idsurat));
	if($rsd!=1){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal re update data disposisi surat"]);
	}
	
	$datadisposisi=$data['datadisposisi'];
	
	if(sizeof($datadisposisi)>0){
		foreach ($datadisposisi as $datadis) {
			$arrdis=$datadis;
			foreach ($arrdis as $obdis) {
				
				$datain=array(
					"idsurat"=>$idsurat,
					"nomorgroup"=>$obdis['nomorgroup'],
					"urutan"=>$obdis['urutan'],
					"nama"=>$obdis['nama']
				);
				
				$rsdis=$db->insert("tb_suratbdk_disposisi_manual",$datain,1);
				if($rsdis<=0){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data disposisi surat"]);
				}
				$iddisposisimanual=$rsdis;
				$datajabatan=$obdis['datajabatan'];
				foreach ($datajabatan as $objab) {
					$datajab=array(
						"idsurat"=>$idsurat,
						"iddisposisimanual"=>$iddisposisimanual,
						"modejabatan"=>$objab['modejabatan'],
						"idjabatan"=>$objab['idjabatan'],
						"view"=>$objab['view'],
						"edit"=>$objab['edit'],
						"hapus"=>$objab['hapus']
					);
					
					$rsinjab=$db->insert("tb_suratbdk_disposisi_manual_jabatan",$datajab,1);
					if($rsinjab<=0){
						$statusin=false;
						array_push($dataerr,["pesan"=>"Gagal input data jabatan (".$objab['idjabatan'].") disposisi surat"]);
					}
					$iddisposisijabatan=$rsinjab;
					$datastatus=$objab['datastatus'];
					foreach ($datastatus as $obst) {
						$datainst=array(
							"iddisposisimanualjabatan"=>$iddisposisijabatan,
							"idstatus"=>$obst['idstatus']
						);
						
						$rsinst=$db->insert("tb_suratbdk_disposisi_manual_idstatus",$datainst);
						if($rsinst!=1) {
							$statusin=false;
							array_push($dataerr,["pesan"=>"Gagal input data akses status jabatan (".$objab['idjabatan'].") ID status ".$obst['idstatus']]);
						}
					}
				}
			}
			
		}
	}
	
	if($statusin){
		$datain=[
			"tanggal_surat"=>$tanggalsurat,
			"idkategori"=>$idkategorisurat,
			"idjenissurat"=>$idjenissurat,
			"idkategorijenissurat"=>$idkategorijenis,
			"iduser"=>$_SESSION['profile']['id'],
			"nomor"=>$nomorsuratpanjang,
			"tujuan"=>$data['tujuan'],
			"alamat_tujuan"=>$data['alamattujuan'],
			"keperluan"=>$data['keperluan'],
			"balasan"=>$balasan,
			"idsuratbalasan"=>$idsuratbalasan,
			"keterangan"=>$data['keterangan'],
			"status"=>$statuspengajuan
		];
		
		$rs=$db->update("tb_surat_keluar",$datain,"id",$data['id']);
		if($rs!=1) {
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal update data surat keluar"]);
		}
		
		$idsuratkeluar=$data['id'];
		$rsdp=$db->query("delete from tb_surat_keluar_dokumen where idsuratkeluar=? ",array($idsuratkeluar));
		if($rsdp!=1){
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal update data dokumen surat keluar"]);
		}
		
		$rsdpsr=$db->query("delete from tb_suratbdk_dokumen where idsurat=? ",array($idsurat));
		if($rsdpsr!=1){
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal update data dokumen surat"]);
		}
		
		if($statusin){
			$datadokumen=$data['datadokumen'];
			foreach ($datadokumen as $obp) {
				$datain=array(
					"idsuratkeluar"=>$idsuratkeluar,
					"iddokumen"=>$obp['iddokumen'],
					"nama"=>$obp['nama'],
				);
				
				$rsp=$db->insert("tb_surat_keluar_dokumen",$datain);
				if($rsp!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data dokumen ".$obp['nama']]);
				}
				
				$datainsr=array(
					"idsurat"=>$idsurat,
					"iddokumen"=>$obp['iddokumen'],
					"nama"=>$obp['nama'],
				);
				
				$rsds=$db->insert("tb_suratbdk_dokumen",$datainsr);
				if($rsds!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data dokumen surat ".$obp['nama']]);
				}
			}
		}
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
		if($data['submitdata']==1){
			$datahasil=$db->setdatadisposisiawal($idsurat);
			if(isset($datahasil['status'])){
				if($datahasil['status']!=1) {
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal set disposisi surat"]);
				}
			}
		}
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function hapusData($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$wh="";
	$datapush=array($_SESSION['profile']['level'],$data['id']);
	$query="select t1.id,t1.idsurat from tb_surat_keluar as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_status_level as t3 on t2.status=t3.idstatus
		where t3.mode=1 and t3.idlevel=? and t1.id=? ".$wh;
	$rsc=$db->loadAssoc($query,$datapush);
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$query="DELETE FROM tb_suratbdk WHERE id=? ";
	$rs=$db->query($query,array($rsc['idsurat']));
	
	$hasil['status']=$rs;
	if($rs==1){
		$hasil['pesan']="Berhasil";
	}
	return json_encode($hasil,true);
}

function datacarictt($data=array())
{
	$mode=0;
	$kunci=array("jenis");
	$alias=array("Jenis Surat");
	$kolom=array("t4.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getdataCatatan($data){
	$db=pDatabase::getInstance();
	$cari="";
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t4.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacarictt(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$wh.="and t1.idsurat=? ";
	array_push($datapush,$data['idsurat']);
	
	if($_SESSION['profile']['pegawai']==1){
		$wh.="and t3.idpegawai=? ";
		array_push($datapush,$_SESSION['profile']['idpegawai']);
	}
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	$query="select SQL_CALC_FOUND_ROWS t1.id,
				t1.`id`,
				t1.`tanggal`,
				t1.`iduser`,
				t1.`idpegawai`,
				t1.`idsurat`,
				t1.`catatan`,
				if(t2.nama is null,'',t2.nama) as namapegawai
			from tb_suratbdk_catatan as t1
			left join tb_pegawai as t2 on t1.idpegawai=t2.id
			inner join tb_suratbdk as t3 on t1.idsurat=t3.id
			inner join tb_master_jenissurat as t4 on t3.idjenissurat=t4.id
			where t1.id>0 ".$wh."
			order by t1.tanggal asc limit ?,?";
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}
	
	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}

function getdokumensurat($data){
	$db=pDatabase::getInstance();
	$query="SELECT  
				t1.nama,
				t1.iddokumen
			FROM tb_surat_keluar_dokumen as t1
		inner join tb_dokumen as t2 on t1.iddokumen=t2.id
		where t1.idsuratkeluar=? ";
	$rs=$db->jsonData($query,array($data['idsuratkeluar']));
	return $rs;
}

function getcatatansurat($data){
	$db=pDatabase::getInstance();
	$query="select 
				t1.`id`,
				t1.`tanggal`,
				t1.`iduser`,
				t1.`idpegawai`,
				t1.`idsurat`,
				t1.`catatan`,
				if(t2.nama is null,'',t2.nama) as namapegawai
			from tb_suratbdk_catatan as t1
			left join tb_pegawai as t2 on t1.idpegawai=t2.id
			inner join tb_suratbdk as t3 on t1.idsurat=t3.id
			inner join tb_master_jenissurat as t4 on t3.idjenissurat=t4.id
			where t1.id>0 and t1.idsurat=?
			order by t1.tanggal asc";
	$rs=$db->jsonData($query,array($data['idsurat']));
	return $rs;
}

function getdatadisposisi($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"data"=>array(),"obj"=>"");
	$query="select t1.id from tb_master_disposisi as t1
		inner join tb_master_disposisi_status as t2 on t1.id=t2.iddisposisi
		where t1.idjenissurat=? and t2.mode=2 ";
	$rsmanual=$db->loadAll($query,array($data['idjenissurat']));
	
	$datagroup=array();
	ob_start();
	for($i=0;$i<sizeof($rsmanual);$i++){
		$query="select 
				t1.id,
				t1.urutan,
				t1.nomorgroup,
				t1.nama,
				t1.jumlah_jabatan
				from tb_suratbdk_disposisi_manual as t1
			where t1.nomorgroup=? and t1.idsurat=? 
			order by t1.urutan asc ";
		$rsdis=$db->loadAll($query,array($i,$data['idsurat']));
		for($n=0;$n<sizeof($rsdis);$n++) {
			$query="select 
					t1.id,
					t1.modejabatan,
					t1.idjabatan,
					t1.jumlah_status,
					if(t2.nama is null,'',t2.nama) as jabatanstruk,
					if(t3.nama is null,'',t3.nama) as jabatanfung,
					t1.view,
					t1.edit,
					t1.hapus
				from tb_suratbdk_disposisi_manual_jabatan as t1
				left join tb_master_jabatan as t2 on t1.idjabatan=t2.id and t1.modejabatan=1
				left join tb_master_jabatan_fungsional as t3 on t1.idjabatan=t3.id and t1.modejabatan=2
				where t1.idsurat=? and t1.iddisposisimanual=? ";
			$datajabatan=$db->loadAll($query,array($data['idsurat'],$rsdis[$n]['id']));
			$rsdis[$n]['datajabatan']=$datajabatan;
			for($x=0;$x<sizeof($datajabatan);$x++){
				$query="select t1.idstatus,
						t2.nama as namastatus
					from tb_suratbdk_disposisi_manual_idstatus as t1
					inner join tb_master_status as t2 on t1.idstatus=t2.id
					where t1.iddisposisimanualjabatan=? ";
				$datastatus=$db->loadAll($query,array($datajabatan[$x]['id']));
				$rsdis[$n]['datajabatan'][$x]['datastatus']=$datastatus;
			}
		}
		array_push($datagroup,$rsdis);
		?>
		<div style="margin-bottom: 8px;">DISPOSISI GROUP KE (<?php echo ($i+1);?>)</div>
		<div id="grid_manual_<?php echo $i;?>"></div>
		<div class="box_button_bawah" style="margin-top: 10px;display: none;" id="boxtambahdis_<?php echo $i;?>">
			<span onclick="suratkeluar.inputnamadisposisi(<?php echo $i;?>)" class="bthijau medium">Input Disposisi</span>&nbsp;&nbsp;
		</div>
		<?php
		$datahtm=ob_get_clean();
	}
	$hasil['data']=$datagroup;
	$hasil['obj']=$datahtm;
	return json_encode($hasil,true);
}

function getdatajabatanstr($data){
	$db=pDatabase::getInstance();
	$query="select * from tb_master_jabatan where status=1 order by id asc";
	$rs=$db->jsonData($query);
	return $rs;
}

function getjabatanfung($data){
	$db=pDatabase::getInstance();
	$query="select * from tb_master_jabatan_fungsional where status=1 order by id asc";
	$rs=$db->jsonData($query);
	return $rs;
}

function getdatasuratbalasan($data){
	$db=pDatabase::getInstance();
	$query="SELECT  
				t1.`id`,
				t1.`tanggal_input`,
				t1.`tanggal_surat`,
				t1.`idpegawai`,
				t1.`iduser`,
				t1.`idkategori`,
				t1.`idjenissurat`,
				t1.`datasurat`,
				t1.`iddisposisi`,
				t1.jumlah_catatan,
				t1.`status`,
				t1.`statusdisposisi`,
				t1.nomor_panjang,
				t2.nama as kategorisurat,
				t3.nama as jenissurat
			FROM tb_suratbdk as t1
		inner join tb_master_kategorisurat as t2 on t1.idkategori=t2.id
		inner join tb_master_jenissurat as t3 on t1.idjenissurat=t3.id
		inner join tb_master_status as a1 on t1.status=a1.id
		where t1.id=? ";
	$rs=$db->loadAssoc($query,array($data['idsurat']));
	return json_encode($rs,true);
}
?>