<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getTabel"=>"getTabel",
		"inputsuratbalasan"=>"inputsuratbalasan",
		"editsuratbalasan"=>"editsuratbalasan",
		"hapusData"=>"hapusData",
		"getdatacatatanbalasan"=>"getdatacatatanbalasan",
		"getdataCatatan"=>"getdataCatatan",
		"getcatatansurat"=>"getcatatansurat"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("hal");
	$alias=array("Hal Surat");
	$kolom=array("t1.hal");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.hal LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$qt="SELECT COUNT(*) as total FROM tb_surat_balasan as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_status as a1 on t2.status=a1.id
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	array_unshift($datapush,$_SESSION['profile']['level'],$_SESSION['profile']['level']);
	
	$query="SELECT t1.`id`,
				t1.`tanggal_input`,
				t1.`tanggal_surat`,
				t1.`nomor`,
				t1.`nomor_panjang`,
				t1.`idsurat`,
				t1.`iduser`,
				t1.`sifat`,
				t1.lampiran,
				t1.hal,
				t1.kepada,
				t1.ditempat,
				t1.`catatan_balasan`,
				t1.`keterangan`,
				t2.`jumlah_catatan`,
				t2.`status`,
				t2.statusdisposisi,
				a1.nama as namastatus,
				a1.bg,a1.warna,
				if(b1.id is null,0,1) as edit,
				if(b2.id is null,0,1) as hapus
			$total as halaman FROM tb_surat_balasan as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_status as a1 on t2.status=a1.id
		left join tb_master_status_level as b1 on t2.status=b1.idstatus and b1.mode=0 and b1.idlevel=?
		left join tb_master_status_level as b2 on t2.status=b2.idstatus and b2.mode=1 and b2.idlevel=?
		WHERE t1.id>0 ".$wh."
		GROUP BY t1.id
		ORDER BY t1.tanggal_surat ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	
	return $rs;
}

function inputsuratbalasan($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$statuspengajuan=20;
	if($data['submitdata']==1) $statuspengajuan=21;
	
	$idkategorisurat=2;
	$idjenissurat=14;
	
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$sekarang=date("Y-m-d");
	
	$datajs=array(
		"datacatatanbalasan"=>json_encode($data['datacatatanbalasan']),
		"sifat"=>$data['sifat'],
		"lampiran"=>$data['lampiran'],
		"hal"=>$data['halsurat'],
		"kepada"=>$data['kepada'],
		"ditempat"=>$data['ditempat'],
		"keterangan"=>$data['keterangan']
	);
	$datasr=array(
		"tanggal_surat"=>$sekarang,
		"iduser"=>$_SESSION['profile']['id'],
		"idkategori"=>$idkategorisurat,
		"idjenissurat"=>$idjenissurat,
		"datasurat"=>json_encode($datajs,true),
		"status"=>$statuspengajuan
	);
	
	$rss=$db->insert("tb_suratbdk",$datasr,1);
	if($rss<=0){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal input data surat"]);
	}
	
	$idsurat=$rss;
	$iddisposisi=0;
	if($data['submitdata']==1){
		$datahasil=$db->getdatadisposisi($idsurat);
		
		if(isset($datahasil['status']) && $datahasil['status']==1){
			$datadisposisi=$datahasil['data']['datajabatan'];
			$iddisposisi=$datahasil['data']['iddisposisi'];
			
			foreach ($datadisposisi as $obd) {
				$datain=array(
					"iduser"=>$_SESSION['profile']['id'],
					"idsurat"=>$idsurat,
					"iddisposisi"=>$iddisposisi,
					"idjabatan"=>$obd['idjabatan'],
					"modejabatan"=>$obd['modejabatan'],
					"urutan"=>$obd['urutan']
				);
				
				$rsdis=$db->insert("tb_suratbdk_disposisi",$datain);
				if($rsdis!=1) {
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data disposisi surat balasan"]);
				}
			}
		}
	}
	
	if($statusin){
		
		$datain=[
			"tanggal_surat"=>$sekarang,
			"idsurat"=>$idsurat,
			"iduser"=>$_SESSION['profile']['id'],
			"sifat"=>$data['sifat'],
			"lampiran"=>$data['lampiran'],
			"hal"=>$data['halsurat'],
			"kepada"=>$data['kepada'],
			"ditempat"=>$data['ditempat'],
			"keterangan"=>$data['keterangan']
		];
		$rs=$db->insert("tb_surat_balasan",$datain,1);
		if($rs<=0) {
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal input data surat balasan"]);
		}
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function editsuratbalasan($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$wh="";
	$datapush=array($_SESSION['profile']['level'],$data['id']);
	if($_SESSION['profile']['pegawai']==1){
		$wh.="and t1.iduser=? ";
		array_push($datapush,$_SESSION['profile']['iduser']);
	}
	
	$query="select t1.id,t1.idsurat,
			t1.status
			from tb_surat_balasan as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_status_level as t3 on t2.status=t3.idstatus
		where t3.mode=0 and t3.idlevel=? and t1.id=? ".$wh;
	$rsc=$db->loadAssoc($query,$datapush);
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$statuspengajuan=$rsc['status'];
	if($data['submitdata']==1) $statuspengajuan=$rsc['status']+1;
	
	$idkategorisurat=2;
	$idjenissurat=14;
	$idsurat=$rsc['idsurat'];
	
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$sekarang=date("Y-m-d");
	
	$datajs=array(
		"datacatatanbalasan"=>json_encode($data['datacatatanbalasan']),
		"sifat"=>$data['sifat'],
		"lampiran"=>$data['lampiran'],
		"hal"=>$data['halsurat'],
		"kepada"=>$data['kepada'],
		"ditempat"=>$data['ditempat'],
		"keterangan"=>$data['keterangan']
	);
	
	$datasr=array(
		"iduser"=>$_SESSION['profile']['id'],
		"datasurat"=>json_encode($datajs,true),
		"status"=>$statuspengajuan
	);
	
	$rss=$db->update("tb_suratbdk",$datasr,"id",$idsurat);
	if($rss!=1){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal update data surat"]);
	}
	
	$iddisposisi=0;
	if($data['submitdata']==1){
		$datahasil=$db->getdatadisposisi($idsurat);
		
		if(isset($datahasil['status']) && $datahasil['status']==1){
			$datadisposisi=$datahasil['data']['datajabatan'];
			$iddisposisi=$datahasil['data']['iddisposisi'];
			
			foreach ($datadisposisi as $obd) {
				$datain=array(
					"iduser"=>$_SESSION['profile']['id'],
					"idsurat"=>$idsurat,
					"iddisposisi"=>$iddisposisi,
					"idjabatan"=>$obd['idjabatan'],
					"modejabatan"=>$obd['modejabatan'],
					"urutan"=>$obd['urutan']
				);
				
				$rsdis=$db->insert("tb_suratbdk_disposisi",$datain);
				if($rsdis!=1) {
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data disposisi surat balasan"]);
				}
			}
		}
	}
	
	if($statusin){
		
		$datain=[
			"tanggal_surat"=>$sekarang,
			"idsurat"=>$idsurat,
			"iduser"=>$_SESSION['profile']['id'],
			"sifat"=>$data['sifat'],
			"lampiran"=>$data['lampiran'],
			"hal"=>$data['halsurat'],
			"kepada"=>$data['kepada'],
			"ditempat"=>$data['ditempat'],
			"keterangan"=>$data['keterangan']
		];
		$rs=$db->update("tb_surat_balasan",$datain,"id",$data['id']);
		if($rs!=1) {
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal update data surat balasan"]);
		}
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function hapusData($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$wh="";
	$datapush=array($_SESSION['profile']['level'],$data['id']);
	if($_SESSION['profile']['pegawai']==1){
		$wh.="and t1.idpegawai=? ";
		array_push($datapush,$_SESSION['profile']['idpegawai']);
	}
	
	$query="select t1.id,t1.idsurat from tb_surat_balasan as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_status_level as t3 on t2.status=t3.idstatus
		where t3.mode=1 and t3.idlevel=? and t1.id=? ".$wh;
	$rsc=$db->loadAssoc($query,$datapush);
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$query="DELETE FROM tb_suratbdk WHERE id=? ";
	$rs=$db->query($query,array($rsc['idsurat']));
	
	$hasil['status']=$rs;
	if($rs==1){
		$hasil['pesan']="Berhasil";
	}
	return json_encode($hasil,true);
}

function datacarictt($data=array())
{
	$mode=0;
	$kunci=array("jenis");
	$alias=array("Jenis Surat");
	$kolom=array("t4.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getdataCatatan($data){
	$db=pDatabase::getInstance();
	$cari="";
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t4.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacarictt(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$wh.="and t1.idsurat=? ";
	array_push($datapush,$data['idsurat']);
	
	if($_SESSION['profile']['pegawai']==1){
		$wh.="and t3.idpegawai=? ";
		array_push($datapush,$_SESSION['profile']['idpegawai']);
	}
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	$query="select SQL_CALC_FOUND_ROWS t1.id,
				t1.`id`,
				t1.`tanggal`,
				t1.`iduser`,
				t1.`idpegawai`,
				t1.`idsurat`,
				t1.`catatan`,
				if(t2.nama is null,'',t2.nama) as namapegawai
			from tb_suratbdk_catatan as t1
			left join tb_pegawai as t2 on t1.idpegawai=t2.id
			inner join tb_suratbdk as t3 on t1.idsurat=t3.id
			inner join tb_master_jenissurat as t4 on t3.idjenissurat=t4.id
			where t1.id>0 ".$wh."
			order by t1.tanggal asc limit ?,?";
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}
	
	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}

function getdatacatatanbalasan($data){
	$db=pDatabase::getInstance();
	$query="SELECT  
				catatan
			FROM tb_surat_tugas_catatan 
		where idsurattugas=? ";
	$rs=$db->jsonData($query,array($data['idsurattugas']));
	return $rs;
}

function getcatatansurat($data){
	$db=pDatabase::getInstance();
	$query="select 
				t1.`id`,
				t1.`tanggal`,
				t1.`iduser`,
				t1.`idpegawai`,
				t1.`idsurat`,
				t1.`catatan`,
				if(t2.nama is null,'',t2.nama) as namapegawai
			from tb_suratbdk_catatan as t1
			left join tb_pegawai as t2 on t1.idpegawai=t2.id
			inner join tb_suratbdk as t3 on t1.idsurat=t3.id
			inner join tb_master_jenissurat as t4 on t3.idjenissurat=t4.id
			where t1.id>0 and t1.idsurat=?
			order by t1.tanggal asc";
	$rs=$db->jsonData($query,array($data['idsurat']));
	return $rs;
}
?>