<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getTabel"=>"getTabel",
		"getdatadokumen"=>"getdatadokumen",
		"simpandokumen"=>"simpandokumen",
		"hapusdokumensk"=>"hapusdokumensk",
		"inputskfungsional"=>"inputskfungsional",
		"editskfungsional"=>"editskfungsional",
		"hapusData"=>"hapusData",
		"setStatus"=>"setStatus"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("nama","nip","nomorsk");
	$alias=array("Nama Pegawai","NIP","Nomor SK");
	$kolom=array("t2.nama","t2.nip","t1.nomor");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t2.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$qt="SELECT COUNT(*) as total FROM tb_pegawai_skfung as t1
		inner join tb_pegawai as t2 on t1.idpegawai=t2.id
		inner join tb_jenis_kelamin as t3 on t2.idjeniskelamin=t3.id
		left join tb_master_jabatan_fungsional as t4 on t1.idjabatan=t4.id
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	array_unshift($datapush,$_SESSION['profile']['level'],$_SESSION['profile']['level']);
	
	$query="SELECT 
			t1.`id`,
			t1.`tanggal_input`,
			t1.`tanggal_sk`,
			t1.tahun,
			t1.`tahun`,
			t1.`iduser`,
			t1.`nomor`,
			t1.`idpegawai`,
			t1.`idjabatan`,
			t1.`iddokumen`,
			t1.jumlah_dokumen,
			t1.`keterangan`,
			t1.`status`,
			t2.nip,
			t2.`tanggal_input`,
			t2.`nama`,
			t2.`idpropinsi`,
			t2.`idkota`,
			t2.`alamat`,
			t2.tempatlahir,
			t2.tanggallahir,
			t2.`idjeniskelamin`,
			t2.`idpendidikan`,
			t2.`namasekolah`,
			t2.`nohp`,
			t2.`email`,
			t2.`notelp`,
			t3.nama as jeniskelamin,
			t4.nama as jabatan,
			a1.nama as namastatus,
			a1.bg,a1.warna,
			if(b1.id is null,0,1) as edit,
			if(b2.id is null,0,1) as hapus,
			$total as halaman FROM tb_pegawai_skfung as t1
		inner join tb_pegawai as t2 on t1.idpegawai=t2.id
		inner join tb_jenis_kelamin as t3 on t2.idjeniskelamin=t3.id
		left join tb_master_jabatan_fungsional as t4 on t1.idjabatan=t4.id
		inner join tb_master_status as a1 on t1.status=a1.id
		left join tb_master_status_level as b1 on t1.status=b1.idstatus and b1.mode=0 and b1.idlevel=?
		left join tb_master_status_level as b2 on t1.status=b2.idstatus and b2.mode=1 and b2.idlevel=?
		WHERE t1.id>0 ".$wh."
		ORDER BY t1.tanggal_sk desc LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	
	return $rs;
}

function getdatadokumen($data){
	$db=pDatabase::getInstance();
	$query="select * from tb_pegawai_skfung_dokumen where idskfung=? ";
	$rs=$db->jsonData($query,array($data['id']));
	return $rs;
}

function simpandokumen($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>"Terjadi kesalahan","data"=>array());
	
	$query="select t1.id,t1.tanggal_sk,t1.idjabatan_lama,
			t1.status,t3.tanggal_sk_struk,t1.idpegawai
		from tb_pegawai_skfung as t1
		inner join tb_master_status_level as t2 on t1.status=t2.idstatus
		inner join tb_pegawai as t3 on t1.idpegawai=t3.id
		where t2.mode=1 and t2.idlevel=? and t1.id=? ";
	$rsc=$db->loadAssoc($query,array($_SESSION['profile']['level'],$data['id']));
	if(!isset($rsc['id'])){
		$hasil['pesan']="Tidak diijinkan";
		return json_encode($hasil,true);
	}
	
	$datain=array(
		"nama"=>$data['nama'],
		"iddokumen"=>$data['iddokumen'],
		"idskfung"=>$data['id'],
	);
	
	$rs=$db->insert("tb_pegawai_skfung_dokumen",$datain,1);
	if($rs<=0){
		$hasil['pesan']="Gagal input dokumen sk";
	}else{
		$hasil['status']=1;
		$hasil['data']['id']=$rs;
	}
	return json_encode($hasil,true);
}

function hapusdokumensk($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$query="select t1.id,t1.tanggal_sk,t1.idjabatan_lama,t1.status 
			from tb_pegawai_skfung as t1
		inner join tb_master_status_level as t2 on t1.status=t2.idstatus
		inner join tb_pegawai_skfung_dokumen as t3 on t1.id=t3.idskfung
		where t2.mode=0 and t2.idlevel=? and t3.id=? ";
	$rsc=$db->loadAssoc($query,array($_SESSION['profile']['level'],$data['id']));
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$query="delete from tb_pegawai_skfung_dokumen where id=? ";
	$rs=$db->query($query,array($data['id']));
	if($rs==1){
		$hasil['status']=1;
	}else{
		$hasil['pesan']=[["pesan"=>"Gagal hapus dokumen sk"]];
	}
	
	return json_encode($hasil,true);
}

function inputskfungsional($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	$tahunsk = date('Y', strtotime($data['tanggalsk']));
	$tanggalsk=$db->d_date($data['tanggalsk']);
	
	$query="select * from tb_pegawai where id=? ";
	$rsp=$db->loadAssoc($query,array($data['idpegawai']));
	if(!isset($rsp['id'])){
		$hasil['pesan']=[["pesan"=>"Data pegawai tidak ditemukan!"]];
		return json_encode($hasil,true);
	}
	
	$idjabatanlama=0;
	if(isset($rsp['idjabatanfung'])) $idjabatanlama=$rsp['idjabatanfung'];
	
	$db->begin();
	$statusin=true;
	$pesanerr=[["pesan"=>"Terjadi Kesalahan"]];
	$datain=[
		"tanggal_sk"=>$tanggalsk,
		"tahun"=>$tahunsk,
		"iduser"=>$_SESSION['profile']['id'],
		"nomor"=>$data['nomor'],
		"idpegawai"=>$data['idpegawai'],
		"idjabatan"=>$data['idjabatan'],
		"keterangan"=>$data['keterangan'],
		"status"=>$data['status']
	];
	if($idjabatanlama>0) $datain['idjabatan_lama']=$idjabatanlama;
	
	$rs=$db->insert("tb_pegawai_skfung",$datain,1);
	if($rs<=0) {
		$statusin=false;
		array_push($pesanerr,["pesan"=>"Gagal input data SK"]);
	}
	
	$idskjabatanfung=$rs;
	if($statusin){
		$datadokumen=$data['datadokumen'];
		if(sizeof($datadokumen)<=0){
			$statusin=false;
			array_push($pesanerr,["pesan"=>"Dokumen SK belum diupload"]);
		}else{
			foreach ($datadokumen as $obd) {
				$datadok=array(
					"nama"=>$obd['nama'],
					"iddokumen"=>$obd['iddokumen'],
					"idskfung"=>$idskjabatanfung
				);
				
				$rsdok=$db->insert("tb_pegawai_skfung_dokumen",$datadok);
				if($rsdok!=1){
					$statusin=false;
					array_push($pesanerr,["pesan"=>"Gagal input dokumen ".$obd['iddokumen']]);
				}
			}
		}
	}
	
	if($statusin && $data['status']==16){
		$query="select id from tb_pegawai_skfung where idpegawai=? and tanggal_sk>? order by tanggal_sk desc";
		$rsck=$db->loadAssoc($query,array($data['idpegawai'],$tanggalsk));
		if(!isset($rsck['id'])){
			$dataup=array(
				"tanggal_sk_fung"=>$tanggalsk,
				"idjabatanfung"=>$data['idjabatan']
			);
			
			$rsup=$db->update("tb_pegawai",$dataup,"id",$data['idpegawai']);
			if($rsup!=1){
				$statusin=false;
				array_push($pesanerr,["pesan"=>"Gagal update SK Pegawai"]);
			}
		}
	}
	if($statusin) {
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
	}
	return json_encode($hasil,true);
}

function editskfungsional($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$query="select t1.id,t1.tanggal_sk,t1.idjabatan_lama,t1.status 
			from tb_pegawai_skfung as t1
		inner join tb_master_status_level as t2 on t1.status=t2.idstatus
		where t2.mode=0 and t2.idlevel=? and t1.id=? ";
	$rsc=$db->loadAssoc($query,array($_SESSION['profile']['level'],$data['id']));
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$tahunsk = date('Y', strtotime($data['tanggalsk']));
	$tanggalsk=$db->d_date($data['tanggalsk']);
	
	$query="select * from tb_pegawai where id=? ";
	$rsp=$db->loadAssoc($query,array($data['idpegawai']));
	if(!isset($rsp['id'])){
		$hasil['pesan']=[["pesan"=>"Data pegawai tidak ditemukan!"]];
		return json_encode($hasil,true);
	}
	
	$idjabatanlama=0;
	if(isset($rsc['idjabatan_lama'])) $idjabatanlama=$rsc['idjabatan_lama'];
	
	$db->begin();
	$statusin=true;
	$pesanerr=[["pesan"=>"Terjadi Kesalahan"]];
	$datain=[
		"tanggal_sk"=>$tanggalsk,
		"tahun"=>$tahunsk,
		"iduser"=>$_SESSION['profile']['id'],
		"nomor"=>$data['nomor'],
		"idpegawai"=>$data['idpegawai'],
		"idjabatan"=>$data['idjabatan'],
		"keterangan"=>$data['keterangan'],
		"status"=>$data['status']
	];
	$rs=$db->update("tb_pegawai_skfung",$datain,"id",$data['id']);
	if($rs!=1) {
		$statusin=false;
		array_push($pesanerr,["pesan"=>"Gagal edit data SK"]);
	}
	if($rsc['tanggal_sk']==$rsp['tanggal_sk_fung']){
		if($statusin && $data['status']==16){
			$dataup=array(
				"tanggal_sk_fung"=>$tanggalsk,
				"idjabatanfung"=>$data['idjabatan']
			);
			
			$rsup=$db->update("tb_pegawai",$dataup,"id",$data['idpegawai']);
			if($rsup!=1){
				$statusin=false;
				array_push($pesanerr,["pesan"=>"Gagal update SK Pegawai"]);
			}
		}else{
			if($data['status']!=16){
				$datapush=array();
				$qr="update tb_pegawai set tanggal_sk_fung=NULL ";
				if($idjabatanlama>0){
					$qr.=",idjabatanfung=? ";
					array_push($datapush,$idjabatanlama);
				}else{
					$qr.=",idjabatanfung=NULL ";
				}
				$qr.="where id=? ";
				array_push($datapush,$rsp['id']);
				$rsup=$db->query($qr,$datapush);
				if($rsup!=1){
					$statusin=false;
					array_push($pesanerr,["pesan"=>"Gagal update SK Pegawai"]);
				}
			}
		}
	}else{
		$query="select id from tb_pegawai_skfung where idpegawai=? and tanggal_sk>? order by tanggal_sk desc";
		$rsck=$db->loadAssoc($query,array($data['idpegawai'],$tanggalsk));
		if(!isset($rsck['id'])){
			$dataup=array(
				"tanggal_sk_fung"=>$tanggalsk,
				"idjabatanfung"=>$data['idjabatan']
			);
			
			$rsup=$db->update("tb_pegawai",$dataup,"id",$data['idpegawai']);
			if($rsup!=1){
				$statusin=false;
				array_push($pesanerr,["pesan"=>"Gagal update SK Pegawai"]);
			}
		}
	}
	
	if($statusin) {
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
	}
	return json_encode($hasil,true);
}

function hapusData($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$query="select t1.id,t1.tanggal_sk,t1.idjabatan_lama,
			t1.status,t3.tanggal_sk_fung,t1.idpegawai
		from tb_pegawai_skfung as t1
		inner join tb_master_status_level as t2 on t1.status=t2.idstatus
		inner join tb_pegawai as t3 on t1.idpegawai=t3.id
		where t2.mode=1 and t2.idlevel=? and t1.id=? ";
	$rsc=$db->loadAssoc($query,array($_SESSION['profile']['level'],$data['id']));
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$db->begin();
	$statusin=true;
	$pesanerr=[["pesan"=>"Terjadi Kesalahan"]];
	
	$query="DELETE FROM tb_pegawai_skfung WHERE id=?";
	$rs=$db->query($query,array($data['id']));
	if($rs!=1) {
		$statusin=false;
		array_push($pesanerr,["pesan"=>"Gagal hapus data sk"]);
	}
	
	if($statusin){
		if($rsc['tanggal_sk_fung']==$rsc['tanggal_sk'] && $rsc['status']==16){
			$datapush=array();
			$qr="update tb_pegawai set tanggal_sk_fung=NULL ";
			if($idjabatanlama>0){
				$qr.=",idjabatanfung=? ";
				array_push($datapush,$idjabatanlama);
			}else{
				$qr.=",idjabatanfung=NULL ";
			}
			$qr.="where id=? ";
			array_push($datapush,$rsc['idpegawai']);
			$rsup=$db->query($qr,$datapush);
			if($rsup!=1){
				$statusin=false;
				array_push($pesanerr,["pesan"=>"Gagal update SK Pegawai"]);
			}
		}
	}
	
	if($statusin) {
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
	}
	return json_encode($hasil,true);
}

?>