<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
if (!isset($_SESSION)) session_start();
$db=pDatabase::getInstance();
$datafungsi=[
	"getTabel"=>"getTabel",
	"getakses"=>"getakses",
	"setStatusakses"=>"setStatusakses",
	"getaksessub"=>"getaksessub",
	"setStatusaksessub"=>"setStatusaksessub",
	"getupload"=>"getupload",
	"setStatusupload"=>"setStatusupload",
	"setStatus"=>"setStatus",
	"getDatacetak"=>"getDatacetak",
	"getdataplugin"=>"getdataplugin",
	"simpanmoduleplugin"=>"simpanmoduleplugin",
	"hapusplugin"=>"hapusplugin",
];

if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("nama","module");
	$alias=array("Nama Module","Module");
	$kolom=array("t1.nama","t1.module");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND (t1.nama LIKE ? or t1.module like ?) ";
			array_push($datapush,$cr,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$qt="SELECT COUNT(*) as total FROM tb_module as t1
		WHERE t1.id>0 and (t1.level<100 and t1.level>0) ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	$query="SELECT t1.id,t1.nama,t1.module,t1.status,t1.jumlah_akses,
			t1.level,
			t1.jumlah_cetak,
			t1.jumlah_upload,
			$total as halaman FROM tb_module as t1
		WHERE t1.id>0 and (t1.level<100 and t1.level>0) ".$wh."
		ORDER BY t1.id ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	return $rs;
}

function setStatus($data){
	$db=pDatabase::getInstance();
	$datainput=[
		"status"=>$data['status']
	];
	$rs=$db->update("tb_module",$datainput,"id",$data['id']);
	return $rs;
}
function getakses($data){
	$db=pDatabase::getInstance();
	$query="select t1.id,t1.nama as namalevel,if(t2.id is null,0,1) as status 
		from tb_level as t1
		left join (select a1.id,a2.level from tb_module as a1 
			inner join tb_module_akses as a2 on a1.id=a2.idmodule where a1.id=? and a2.status=1) as t2 on t1.id=t2.level
		where t1.id>=?
		order by t1.id desc";
	$rs=$db->jsonData($query,array($data[1],$data[2]));
	return $rs;
}

function setStatusakses($data){
	$db=pDatabase::getInstance();
	
	$query="";
	$rs=0;
	if($data['status']==0){
		$query="delete from tb_module_akses where idmodule=? and level=?";
		$rs=$db->query($query,array($data['idmodule'],$data['level']));
	}else{
		$datainput=[
			"idmodule"=>$data['idmodule'],
			"level"=>$data['level'],
			"status"=>1
		];
		$rs=$db->insert("tb_module_akses",$datainput);
	}
	return $rs;
}

function getaksessub($data){
	$db=pDatabase::getInstance();
	$query="select t1.id,t1.nama as namasublevel,t2.nama as namalevel,t1.idlevel,t1.kode,
			if(t4.id is null,0,t4.id) as status	
				from tb_level_sub as t1
			inner join tb_level as t2 on t1.idlevel=t2.id
			inner join tb_module_akses as t3 on t1.idlevel=t3.level and t3.idmodule=?
			left join tb_module_akses_sub as t4 on t1.idlevel=t4.level and t1.kode=t4.kodesub and t4.idmodule=t3.idmodule
		order by t1.idlevel desc,t1.kode asc";
	$rs=$db->jsonData($query,array($data['id']));
	
	return $rs;
}

function setStatusaksessub($data){
	$db=pDatabase::getInstance();
	
	$query="";
	$rs=0;
	if($data['status']==0){
		$query="delete from tb_module_akses_sub where idmodule=? and level=? and kodesub=?";
		$rs=$db->query($query,array($data['idmodule'],$data['idlevel'],$data['kodesub']));
	}else{
		$datainput=[
			"idmodule"=>$data['idmodule'],
			"level"=>$data['idlevel'],
			"kodesub"=>$data['kodesub'],
			"status"=>1
		];
		$rs=$db->insert("tb_module_akses_sub",$datainput);
	}
	return $rs;
}

function getupload($data){
	$db=pDatabase::getInstance();
	$query="select 
			t1.`id`,
			t1.`jenis`,
			t1.`tipefile`,
			if(t2.id is null,0,1) as status 
		from tb_jenis_konten as t1
		left join tb_module_upload as t2 on t1.id=t2.idjenis and t2.idmodule=?";
	$rs=$db->jsonData($query,array($data['idmodule']));
	return $rs;
}

function setStatusupload($data){
	$db=pDatabase::getInstance();
	$status=$data['status'];
	if($status==0){
		$query="delete from tb_module_upload where idjenis=? and idmodule=?";
		$rs=$db->query($query,array($data['idjenis'],$data['idmodule']));
		return $rs;
	}else if($status==1){
		$datainput=[
			"idmodule"=>$data['idmodule'],
			"idjenis"=>$data['idjenis']
		];
		$rs=$db->insert("tb_module_upload",$datainput);
		return $rs;
	}
	return false;
}

function getDatacetak($data){
	$db=pDatabase::getInstance();
	$query="select 
			t1.`id`,
			t1.`idmodule`,
			t1.`idplugin`,
			t2.nama as namaplugin
		from tb_module_cetak as t1
		inner join tb_plugin_cetak as t2 on t1.idplugin=t2.id
		where t1.idmodule=? ";
	$rs=$db->jsonData($query,array($data['idmodule']));
	return $rs;
}


function datacariplugin($data=array())
{
	$mode=0;
	$kunci=array("nama");
	$alias=array("Nama Plugin");
	$kolom=array("t1.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getdataplugin($data){
	$db=pDatabase::getInstance();
	$cari=$data['cari'];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacariplugin(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$wh.="and t1.id not in (select idplugin as id from tb_module_cetak where idmodule=? and idplugin is not null)";
	array_push($datapush,$data['idmodule']);
	
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	
	$query="SELECT 
				SQL_CALC_FOUND_ROWS t1.id,
					t1.`id`,
					t1.`nama`,
					t1.`module`
			FROM tb_plugin_cetak as t1
		WHERE t1.id>0 and t1.status=1 ".$wh."
		ORDER BY t1.id asc LIMIT ?,?";
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}
	
	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}

function simpanmoduleplugin($data){
	$db=pDatabase::getInstance();
	$dataplugin=$data['dataplugin'];
	if(sizeof($dataplugin)<=0) return 2;
	$db->begin();
	$status=true;
	for($i=0;$i<sizeof($dataplugin);$i++){
		$datainput=array(
			"idmodule"=>$data['idmodule'],
			"idplugin"=>$dataplugin[$i],
		);
		
		$rs=$db->insert("tb_module_cetak",$datainput);
		if($rs!=1) $status=false;
	}
	if($status){
		$db->commit();
		return true;
	}else{
		$db->rollback();
		return false;
	}
}

function hapusplugin($data){
	$db=pDatabase::getInstance();
	$query="DELETE FROM tb_module_cetak WHERE id=?";
	$rs=$db->query($query,array($data['id']));
	return $rs;
}

?>