<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"getTabel"=>"getTabel",
		"datacari01"=>"datacari01",
		"inputstatus"=>"inputstatus",
		"editstatus"=>"editstatus",
		"hapusData"=>"hapusData",
		"setStatus"=>"setStatus",
		"getmodulestatus"=>"getmodulestatus",
		"getdatamodule"=>"getdatamodule",
		"getdatamoduleview"=>"getdatamoduleview",
		"inputmodule"=>"inputmodule",
		"hapusmodule"=>"hapusmodule",
		"getlevelnotifikasi"=>"getlevelnotifikasi",
		"setstatuslevel"=>"setstatuslevel",
		"getmodulestatusview"=>"getmodulestatusview",
		"inputmoduleview"=>"inputmoduleview",
		"hapusmoduleview"=>"hapusmoduleview",
		"getstatusedit"=>"getstatusedit",
		"setStatusedit"=>"setStatusedit",
		"getstatushapus"=>"getstatushapus",
		"setStatushapus"=>"setStatushapus",
		"getstatusvalidasi"=>"getstatusvalidasi",
		"setStatusvalidasi"=>"setStatusvalidasi",
		"hapusemuaview"=>"hapusemuaview",
		"hapusemuamodakses"=>"hapusemuamodakses",
		"updateKode"=>"updateKode"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}
function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("nama");
	$alias=array("Nama Status");
	$kolom=array("t1.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	$kategori=$data['kategori'];
	if($kategori>0){
		$wh.="and t1.idkategori=? ";
		array_push($datapush,$kategori);
	}
	$qt="SELECT COUNT(*) as total FROM tb_master_status as t1
		inner join tb_kategori_status as t2 on t1.idkategori=t2.id
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	$query="SELECT t1.`id`,
				t1.`idkategori`,
				t1.`nama`,
				t1.`jumlah_module`,
				t1.`jumlah_notifikasi`,
				t1.`jumlah_view`,
				t1.jumlah_validasi,
				t1.`urutan`,
				t1.`edit`,
				t1.`hapus`,
				t1.`update_revis`,
				t1.`bukakunci`,
				t1.`bg`,
				t1.`warna`,
				t1.`status`,
				t1.jumlah_edit,
				t1.jumlah_hapus,
				t2.nama as kategori,
			$total as halaman FROM tb_master_status as t1
		inner join tb_kategori_status as t2 on t1.idkategori=t2.id
		WHERE t1.id>0 ".$wh."
		ORDER BY t1.idkategori asc,t1.id ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	
	return $rs;
}
function inputstatus($data){
	$db=pDatabase::getInstance();
	
	$datainput=[
		"id"=>$data['iddatamasterstatus'],
		"idkategori"=>$data['idkategori'],
		"nama"=>$data['nama'],
		"bg"=>$data['bg'],
		"warna"=>$data['warna']
	];
	$rs=$db->insert("tb_master_status",$datainput);
	return $rs;
}
function editstatus($data){
	$db=pDatabase::getInstance();
	$datainput=[
		"id"=>$data['iddatamasterstatus'],
		"idkategori"=>$data['idkategori'],
		"nama"=>$data['nama'],
		"bg"=>$data['bg'],
		"warna"=>$data['warna']
	];
	$rs=$db->update("tb_master_status",$datainput,"id",$data['id']);
	return $rs;
	
}
function hapusData($data){
	$db=pDatabase::getInstance();
	
	$query="DELETE FROM tb_master_status WHERE id=?";
	$rs=$db->query($query,array($data['id']));
	return $rs;
}

function setStatus($data){
	$db=pDatabase::getInstance();
	$datainput=[
		"status"=>$data['status']
	];
	$rs=$db->update("tb_master_status",$datainput,"id",$data['id']);
	return $rs;
}

function getmodulestatus($data){
	$db=pDatabase::getInstance();
	$query="select t1.id,t1.nama,t2.id as idstatus
		from tb_module as t1
		inner join tb_master_status_module as t2 on t1.id=t2.idmodule and t2.idstatus=?
		order by t1.nama asc";
	$rs=$db->jsonData($query,array($data['idstatus']));
	return $rs;
}
function datacarimodule($data=array())
{
	$mode=0;
	$kunci=array("nama");
	$alias=array("Nama Module");
	$kolom=array("nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getdatamodule($data){
	$db=pDatabase::getInstance();
	
	$db=pDatabase::getInstance();
	$cari=$data['cari'];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND (nama LIKE ? || module like ?) ";
			array_push($datapush,$cr,$cr);
		}else{
			$datacari=$db->datacari(datacarimodule(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	array_push($datapush,$data['idstatus']);
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	$query="select SQL_CALC_FOUND_ROWS id,
			id,
			nama 
		from tb_module where status=1 ".$wh."
		and id not in (select idmodule as id from tb_master_status_module where idstatus=? and idmodule is not null)
		ORDER BY id ASC LIMIT ?,?";
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}
	
	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}

function getdatamoduleview($data){
	$db=pDatabase::getInstance();
	
	$db=pDatabase::getInstance();
	$cari=$data['cari'];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND (nama LIKE ? || module like ?) ";
			array_push($datapush,$cr,$cr);
		}else{
			$datacari=$db->datacari(datacarimodule(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	array_push($datapush,$data['idstatus']);
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	$query="select SQL_CALC_FOUND_ROWS id,
			id,
			nama 
		from tb_module where status=1 ".$wh."
		and id not in (select idmodule as id from tb_master_status_view where idstatus=? and idmodule is not null)
		ORDER BY id ASC LIMIT ?,?";
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}
	
	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}

function inputmodule($data){
	$db=pDatabase::getInstance();
	$db->begin();
	$status=true;
	
	$datamodule=$data['idmodule'];
	foreach ($datamodule as $obj) {
		$datainput=array(
			"idstatus"=>$data['idstatus'],
			"idmodule"=>$obj
		);
		$rsin=$db->insert("tb_master_status_module",$datainput);
		if($rsin!=1) $status=false;
	}
	
	if($status){
		$db->commit();
		return true;
	}else{
		$db->rollback();
		return false;
	}
	
}
function hapusmodule($data){
	$db=pDatabase::getInstance();
	$query="delete from tb_master_status_module where idmodule=? and idstatus=? ";
	$rsd=$db->query($query,array($data['idmodule'],$data['idstatus']));
	return $rsd;
	
}

function getlevelnotifikasi($data){
	$db=pDatabase::getInstance();
	$query="select t1.id,t1.nama,
			if(t2.id is null,0,1) as status,
			if(t2.id is null,0,t2.id) as idstatus
		from tb_level as t1
		left join tb_master_status_notifikasi as t2 on t1.id=t2.idlevel and t2.idstatus=?
		order by t1.id desc";
	$rs=$db->jsonData($query,array($data['idstatus']));
	return $rs;
}

function setstatuslevel($data){
	$db=pDatabase::getInstance();
	$status=$data['status'];
	if($status==0){
		$query="delete from tb_master_status_notifikasi where idstatus=? and idlevel=? ";
		$rsd=$db->query($query,array($data['idstatus'],$data['idlevel']));
		return $rsd;
	}else if($status==1){
		$datainput=[
			"idstatus"=>$data['idstatus'],
			"idlevel"=>$data['idlevel']
		];
		
		$rsi=$db->insert("tb_master_status_notifikasi",$datainput);
		return $rsi;
	}
	
}

function getmodulestatusview($data){
	$db=pDatabase::getInstance();
	$query="select t1.id,t1.nama,t2.id as idstatus
		from tb_module as t1
		inner join tb_master_status_view as t2 on t1.id=t2.idmodule and t2.idstatus=?
		order by t1.nama asc";
	$rs=$db->jsonData($query,array($data['idstatus']));
	return $rs;
}

function inputmoduleview($data){
	$db=pDatabase::getInstance();
	$db->begin();
	$status=true;
	
	$datamodule=$data['idmodule'];
	foreach ($datamodule as $obj) {
		$datainput=array(
			"idstatus"=>$data['idstatus'],
			"idmodule"=>$obj
		);
		$rsin=$db->insert("tb_master_status_view",$datainput);
		if($rsin!=1) $status=false;
	}
	
	if($status){
		$db->commit();
		return true;
	}else{
		$db->rollback();
		return false;
	}
}

function hapusmoduleview($data){
	$db=pDatabase::getInstance();
	$query="delete from tb_master_status_view where idmodule=? and idstatus=? ";
	$rsd=$db->query($query,array($data['idmodule'],$data['idstatus']));
	return $rsd;
	
}

function getstatusedit($data){
	$db=pDatabase::getInstance();
	$query="select t1.id,t1.nama,
			if(t2.id is null,0,1) as statusedit
			from tb_level as t1
		left join tb_master_status_level as t2 on t1.id=t2.idlevel and t2.idstatus=? and t2.mode=0 
		order by t1.id desc";
	$rsd=$db->jsonData($query,array($data['idstatus']));
	return $rsd;
}

function setStatusedit($data){
	$db=pDatabase::getInstance();
	if($data['status']==1){
		$datainput=array("mode"=>0,
			"idstatus"=>$data['idstatus'],
			"idlevel"=>$data['idlevel']);
		$rs=$db->insert("tb_master_status_level",$datainput);
	}else{
		$query="delete from tb_master_status_level WHERE idstatus=? and idlevel=? and mode=0";
		$rs=$db->query($query,array($data['idstatus'],$data['idlevel']));
	}
	
	return $rs;
}

function getstatushapus($data){
	$db=pDatabase::getInstance();
	$query="select t1.id,t1.nama,
			if(t2.id is null,0,1) as statushapus
			from tb_level as t1
		left join tb_master_status_level as t2 on t1.id=t2.idlevel and t2.idstatus=? and t2.mode=1 
		order by t1.id desc";
	$rsd=$db->jsonData($query,array($data['idstatus']));
	return $rsd;
}

function setStatushapus($data){
	$db=pDatabase::getInstance();
	if($data['status']==1){
		$datainput=array("mode"=>1,
			"idstatus"=>$data['idstatus'],
			"idlevel"=>$data['idlevel']);
		$rs=$db->insert("tb_master_status_level",$datainput);
	}else{
		$query="delete from tb_master_status_level WHERE idstatus=? and idlevel=? and mode=1";
		$rs=$db->query($query,array($data['idstatus'],$data['idlevel']));
	}
	
	return $rs;
}

function getstatusvalidasi($data){
	$db=pDatabase::getInstance();
	$query="select t1.id,t1.nama,
			if(t2.id is null,0,1) as statusvalidasi
			from tb_level as t1
		left join tb_master_status_level as t2 on t1.id=t2.idlevel and t2.idstatus=? and t2.mode=2 
		order by t1.id desc";
	$rsd=$db->jsonData($query,array($data['idstatus']));
	return $rsd;
}

function setStatusvalidasi($data){
	$db=pDatabase::getInstance();
	if($data['status']==1){
		$datainput=array("mode"=>2,
			"idstatus"=>$data['idstatus'],
			"idlevel"=>$data['idlevel']);
		$rs=$db->insert("tb_master_status_level",$datainput);
	}else{
		$query="delete from tb_master_status_level WHERE idstatus=? and idlevel=? and mode=2";
		$rs=$db->query($query,array($data['idstatus'],$data['idlevel']));
	}
	
	return $rs;
}

function hapusemuaview($data){
	$db=pDatabase::getInstance();
	$query="delete from tb_master_status_view WHERE idstatus=?";
	$rs=$db->query($query,array($data['idstatus']));
	return $rs;
}

function hapusemuamodakses($data){
	$db=pDatabase::getInstance();
	$query="delete from tb_master_status_module WHERE idstatus=?";
	$rs=$db->query($query,array($data['idstatus']));
	return $rs;
}

function updateKode($data){
	$db=pDatabase::getInstance();
	$dataup=[
		"id"=>$data['kode']
	];
	
	$rs=$db->update("tb_master_status",$dataup,"id",$data['id']);
	return $rs;
}
?>