<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getTabel"=>"getTabel",
		"getGambarproduk"=>"getGambarproduk",
		"inputGambarproduk"=>"inputGambarproduk",
		"editGambarproduk"=>"editGambarproduk",
		"hapusDatagambar"=>"hapusDatagambar",
		"inputproduk"=>"inputproduk",
		"editproduk"=>"editproduk",
		"hapusData"=>"hapusData",
		"setStatus"=>"setStatus"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("nama");
	$alias=array("Nama produk");
	$kolom=array("t1.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$qt="SELECT COUNT(*) as total FROM tb_produk as t1
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	$query="SELECT *,
			$total as halaman FROM tb_produk as t1		
		WHERE t1.id>0 ".$wh."
		ORDER BY t1.kode ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	return $rs;
}

function getGambarproduk($data){
	$db=pDatabase::getInstance();
	$query="select t1.`id`,
				t1.`idgambar`,
				t1.`idproduk`,
				t1.`nama`,
				t2.nama_awal,
				t2.nama_baru
		from tb_produk_gambar as t1 
		inner join tb_dokumen as t2 on t1.idgambar=t2.id
		where t1.idproduk=?";
	$rs=$db->jsonData($query,array($data['idproduk']));
	return $rs;
}

function inputGambarproduk($data){
	$db=pDatabase::getInstance();
	$datain=[
		"nama"=>$data['nama'],
		"idgambar"=>$data['idgambar'],
		"idproduk"=>$data['idproduk']
	];
	
	$rs=$db->insert("tb_produk_gambar",$datain);
	return $rs;
}

function editGambarproduk($data){
	$db=pDatabase::getInstance();
	$datain=[
		"nama"=>$data['nama'],
		"idgambar"=>$data['idgambar']
	];
	
	$rs=$db->update("tb_produk_gambar",$datain,"id",$data['id']);
	return $rs;
}

function hapusDatagambar($data){
	$db=pDatabase::getInstance();
	
	$query="select * from tb_produk_gambar where id=? ";
	$rsg=$db->loadAssoc($query,array($data['id']));
	
	$query="delete from tb_produk_gambar where id=? ";
	$rs=$db->query($query,array($data['id']));
	
	if($rs==1 && isset($rsg['idgambar'])){
		$hapus=$db->hapusdokumen($rsg['idgambar']);
	}
	
	return $rs;
}

function inputproduk($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]],"data"=>array());
	
	$query="select id from tb_produk where kode=? ";
	$rs=$db->loadAssoc($query,array($data['kode']));
	if(isset($rs['id'])){
		$hasil['pesan']=[["pesan"=>"Kode produk sudah dipakai"]];
		return json_encode($hasil,true);
	}
	
	$dataerr=array();
	$db->begin();
	$statusin=true;
	
	global $config_data;
	$keterangan=strip_tags($data['keterangan'],$config_data['tag_deskripsi']);
	
	$datain=[
		"nama"=>strip_tags($data['nama']),
		"kode"=>strip_tags($data['kode']),
		"keterangan"=>$keterangan,
		"harga"=>strip_tags($data['harga']),
		"point"=>strip_tags($data['point'])
	];
	
	$rs=$db->insert("tb_produk",$datain,1,1);
	if($rs<=0){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal input data produk"]);
	}
	
	if($statusin){
		$datagambar=$data['datagambar'];
		if(sizeof($datagambar)>0){
			foreach ($datagambar as $obg) {
				$datag=[
					"nama"=>$obg['nama'],
					"idgambar"=>$obg['idgambar'],
					"idproduk"=>$rs
				];
				
				$rsg=$db->insert("tb_produk_gambar",$datag);
				if($rsg!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data gambar dengan nama ".$obg['nama']]);
				}
			}
		}
	}
	$hasil['status']=$statusin;
	$hasil['pesan']=$dataerr;
	
	if($statusin){
		$db->commit();
	}else{
		$db->rollback();
	}
	
	return json_encode($hasil,true);
}

function editproduk($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]],"data"=>array());
	
	$query="select id from tb_produk where kode=? and id!=? ";
	$rs=$db->loadAssoc($query,array($data['kode'],$data['id']));
	if(isset($rs['id'])){
		$hasil['pesan']=[["pesan"=>"Kode produk sudah dipakai"]];
		return json_encode($hasil,true);
	}
	
	$dataerr=array();
	$db->begin();
	$statusin=true;
	
	global $config_data;
	$keterangan=strip_tags($data['keterangan'],$config_data['tag_deskripsi']);
	
	$datain=[
		"nama"=>strip_tags($data['nama']),
		"kode"=>strip_tags($data['kode']),
		"keterangan"=>$keterangan,
		"harga"=>strip_tags($data['harga']),
		"point"=>strip_tags($data['point'])
	];
	
	$rs=$db->update("tb_produk",$datain,"id",$data['id'],1);
	if($rs<=0){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal update data produk"]);
	}
	
	$hasil['status']=$statusin;
	$hasil['pesan']=$dataerr;
	
	if($statusin){
		$db->commit();
	}else{
		$db->rollback();
	}
	
	return json_encode($hasil,true);
}

function hapusData($data){
	$db=pDatabase::getInstance();
	$query="select * from tb_produk_gambar where idproduk=? ";
	$rsp=$db->loadAll($query,array($data['id']));
	
	$query="DELETE FROM tb_produk WHERE id=?";
	$rs=$db->query($query,array($data['id']));
	
	if($rs==1 && $rsp!=null && sizeof($rsp)>0){
		foreach ($rsp as $obg) {
			$db->hapusdokumen($obg['idgambar']);
		}
	}
	
	return $rs;
}

function setStatus($data){
	$db=pDatabase::getInstance();
	$dataup=[
		"status"=>$data['status']
	];
	$rs=$db->update("tb_produk",$dataup,"id",$data['id']);
	return $rs;
}
?>