<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getTabel"=>"getTabel",
		"getdatakota"=>"getdatakota",
		"inputmasterpegawai"=>"inputmasterpegawai",
		"editmasterpegawai"=>"editmasterpegawai",
		"hapusData"=>"hapusData",
		"getdatalampiran"=>"getdatalampiran",
		"inputLampiran"=>"inputLampiran",
		"editLampiran"=>"editLampiran",
		"hapusdataLampiran"=>"hapusdataLampiran",
		"inputDokumen"=>"inputDokumen",
		"hapusdatadokumen"=>"hapusdatadokumen",
		"getdatalampirandokumen"=>"getdatalampirandokumen"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("nama","nip","jabatanstr","jabatanfung");
	$alias=array("Nama Pegawai","NIP","Jabatan Strukturan","Jabatan Fungsional");
	$kolom=array("t1.nama","t1.nip","t4.nama","t5.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$qt="SELECT COUNT(*) as total FROM tb_pegawai as t1
		inner join tb_jenis_kelamin as t2 on t1.idjeniskelamin=t2.id
		left join tb_master_golongan as t3 on t1.idgolongan=t3.id
		left join tb_master_jabatan as t4 on t1.idjabatanstruk=t4.id
		left join tb_master_jabatan_fungsional as t5 on t1.idjabatanfung=t5.id
		inner join tb_master_status as a1 on t1.status=a1.id
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	array_unshift($datapush,$_SESSION['profile']['level'],$_SESSION['profile']['level']);
	
	$query="SELECT t1.`id`,
			t1.nip,
			t1.`tanggal_input`,
			t1.`nama`,
			t1.`idpropinsi`,
			t1.`idkota`,
			t1.`alamat`,
			t1.tempatlahir,
			t1.tanggallahir,
			t1.`idjeniskelamin`,
			t1.`idgolongan`,
			t1.`idjabatanstruk`,
			t1.`idjabatanfung`,
			t1.`idpendidikan`,
			t1.`namasekolah`,
			t1.`nohp`,
			t1.`email`,
			t1.`notelp`,
			t1.`jumlah_lampiran`,
			t1.`tanggal_sk_gol`,
			t1.`tanggal_sk_struk`,
			t1.`tanggal_sk_fung`,
			t1.`tanggal_sk_awal` as tanggalskawal,
			t1.statusasn,
			t1.`status`,
			t2.nama as jeniskelamin,
			if(t3.kode is null,'',t3.kode) as golongan,
			if(t4.nama is null,'',t4.nama) as jabatanstruk,
			if(t5.nama is null,'',t5.nama) as jabatanfung,
			t6.nama as namastatusasn,
			a1.nama as namastatus,
			a1.bg,a1.warna,
			if(b1.id is null,0,1) as edit,
			if(b2.id is null,0,1) as hapus,
			$total as halaman FROM tb_pegawai as t1
		inner join tb_jenis_kelamin as t2 on t1.idjeniskelamin=t2.id
		left join tb_master_golongan as t3 on t1.idgolongan=t3.id
		left join tb_master_jabatan as t4 on t1.idjabatanstruk=t4.id
		left join tb_master_jabatan_fungsional as t5 on t1.idjabatanfung=t5.id
		inner join tb_master_statusasn as t6 on t1.statusasn=t6.id
		inner join tb_master_status as a1 on t1.status=a1.id
		left join tb_master_status_level as b1 on t1.status=b1.idstatus and b1.mode=0 and b1.idlevel=?
		left join tb_master_status_level as b2 on t1.status=b2.idstatus and b2.mode=1 and b2.idlevel=?
		WHERE t1.id>0 ".$wh."
		ORDER BY t1.id ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	
	return $rs;
}

function getdatakota($data){
	$db=pDatabase::getInstance();
	
	$query="SELECT * FROM tb_kota
		WHERE idpropinsi=?";
	$rs=$db->jsonData($query,array($data['idpropinsi']));
	
	return $rs;
}

function inputmasterpegawai($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	$db->begin();
	$statusin=true;
	
	$tanggallahir=$db->d_date($data['tanggallahir']);
	$tanggalskawal=$db->d_date($data['tanggalskawal']);
	$datain=[
		"nama"=>$data['nama'],
		"nip"=>$data['nip'],
		"idpropinsi"=>$data['idpropinsi'],
		"idkota"=>$data['idkota'],
		"alamat"=>$data['alamat'],
		"tempatlahir"=>$data['tempatlahir'],
		"tanggallahir"=>$tanggallahir,
		"idjeniskelamin"=>$data['idjeniskelamin'],
		"idgolongan"=>$data['idgolongan'],
		"idpendidikan"=>$data['idpendidikan'],
		"namasekolah"=>$data['namasekolah'],
		"nohp"=>$data['nohp'],
		"email"=>$data['email'],
		"notelp"=>$data['notelp'],
		"tanggal_sk_awal"=>$tanggalskawal,
		"statusasn"=>$data['statusasn'],
		"status"=>$data['status']
	];
	
	if($data['idgolongan']>0){
		$datain['idgolongan']=$data['idgolongan'];
	}
	
	if($data['idjabatanstruk']>0){
		$datain['idjabatanstruk']=$data['idjabatanstruk'];
	}
	
	if($data['idjabatanfung']>0){
		$datain['idjabatanfung']=$data['idjabatanfung'];
	}
	
	$rs=$db->insert("tb_pegawai",$datain,1);
	if($rs<=0) $statusin=false;
	$idpegawai=$rs;
	
	$datalampiran=$data['datalampiran'];
	for($i=0;$i<sizeof($datalampiran);$i++){
		$datalamp=array(
			"idpegawai"=>$idpegawai,
			"nama"=>$datalampiran[$i]['nama']
		);
		
		$rslamp=$db->insert("tb_pegawai_lampiran",$datalamp,1);
		if($rslamp<=0) $statusin=false;
		
		$idlampiran=$rslamp;
		if($statusin){
			$datadokumen=$datalampiran[$i]['datadokumen'];
			foreach ($datadokumen as $obd) {
				$dataindok=array(
					"nama"=>$obd['nama'],
					"idlampiran"=>$idlampiran,
					"iddokumen"=>$obd['iddokumen']
				);
				
				$rsindok=$db->insert("tb_pegawai_lampiran_dokumen",$dataindok);
				if($rsindok!=1) $statusin=false;
			}
		}
	}
	
	$hasil['status']=$statusin;
	if($statusin){
		$db->commit();
	}else{
		$db->rollback();
	}
	
	return json_encode($hasil,true);
}
function editmasterpegawai($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$query="select t1.id from tb_pegawai as t1
		inner join tb_master_status_level as t2 on t1.status=t2.idstatus
		where t2.mode=0 and t2.idlevel=? and t1.id=? ";
	$rsc=$db->loadAssoc($query,array($_SESSION['profile']['level'],$data['id']));
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$tanggallahir=$db->d_date($data['tanggallahir']);
	$tanggalskawal=$db->d_date($data['tanggalskawal']);
	$datain=[
		"nama"=>$data['nama'],
		"nip"=>$data['nip'],
		"idpropinsi"=>$data['idpropinsi'],
		"idkota"=>$data['idkota'],
		"alamat"=>$data['alamat'],
		"tempatlahir"=>$data['tempatlahir'],
		"tanggallahir"=>$tanggallahir,
		"idjeniskelamin"=>$data['idjeniskelamin'],
		"idgolongan"=>$data['idgolongan'],
		"idpendidikan"=>$data['idpendidikan'],
		"namasekolah"=>$data['namasekolah'],
		"nohp"=>$data['nohp'],
		"email"=>$data['email'],
		"notelp"=>$data['notelp'],
		"tanggal_sk_awal"=>$tanggalskawal,
		"statusasn"=>$data['statusasn'],
		"status"=>$data['status']
	];
	
	if($data['idgolongan']>0){
		$datain['idgolongan']=$data['idgolongan'];
	}
	
	if($data['idjabatanstruk']>0){
		$datain['idjabatanstruk']=$data['idjabatanstruk'];
	}
	
	if($data['idjabatanfung']>0){
		$datain['idjabatanfung']=$data['idjabatanfung'];
	}

	$rs=$db->update("tb_pegawai",$datain,"id",$data['id']);
	if($rs!=1) {
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal update data pegawai"]);
	}
	
	if($statusin){
		if($data['idjabatanstruk']<=0){
			$rsu=$db->query("update tb_pegawai set idjabatanstruk=NULL where id=? ",
				array($data['id']));
			if($rsu!=1){
				$statusin=false;
				array_push($dataerr,["pesan"=>"Gagal update data jabatan struktural pegawai"]);
			}
			
		}
		
		if($data['idjabatanfung']<=0){
			$rsu=$db->query("update tb_pegawai set idjabatanfung=NULL where id=? ",
				array($data['id']));
			if($rsu!=1){
				$statusin=false;
				array_push($dataerr,["pesan"=>"Gagal update data jabatan fungsional pegawai"]);
			}
		}

		if($data['idgolongan']<=0){
			$rsu=$db->query("update tb_pegawai set idgolongan=NULL where id=? ",
				array($data['id']));
			if($rsu!=1){
				$statusin=false;
				array_push($dataerr,["pesan"=>"Gagal update data golongan pegawai"]);
			}
		}
	}

	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
	}
	return json_encode($hasil,true);
}

function hapusData($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$query="select t1.id from tb_pegawai as t1
		inner join tb_master_status_level as t2 on t1.status=t2.idstatus
		where t2.mode=1 and t2.idlevel=? and t1.id=? ";
	$rsc=$db->loadAssoc($query,array($_SESSION['profile']['level'],$data['id']));
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$query="DELETE FROM tb_pegawai WHERE id=?";
	$rs=$db->query($query,array($data['id']));
	if($rs==1) $hasil['status']=1;
	return json_encode($hasil,true);
}

function getdatalampiran($data){
	$db=pDatabase::getInstance();
	$query="select * from tb_pegawai_lampiran where idpegawai=? ";
	$rslamp=$db->loadAll($query,array($data['idpegawai']));
	for($i=0;$i<sizeof($rslamp);$i++) {
		$query="select nama,iddokumen from tb_pegawai_lampiran_dokumen where idlampiran=? ";
		$rsdok=$db->loadAll($query,array($rslamp[$i]['id']));
		$rslamp[$i]['datadokumen']=$rsdok;
	}
	return json_encode($rslamp,true);
}

function inputLampiran($data){
	$db=pDatabase::getInstance();
	$datain=array(
		"idpegawai"=>$data['idpegawai'],
		"nama"=>$data['nama']
	);
	$rs=$db->insert("tb_pegawai_lampiran",$datain);
	return $rs;
}

function editLampiran($data){
	$db=pDatabase::getInstance();
	$datain=array(
		"nama"=>$data['nama']
	);
	$rs=$db->update("tb_pegawai_lampiran",$datain,"id",$data['id']);
	return $rs;
}

function hapusdataLampiran($data){
	$db=pDatabase::getInstance();
	$query="delete from tb_pegawai_lampiran where id=? ";
	$rs=$db->query($query,array($data['id']));
	return $rs;
}

function inputDokumen($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>"");
	$datain=array(
		"idlampiran"=>$data['idlampiran'],
		"nama"=>$data['nama'],
		"iddokumen"=>$data['iddokumen']
	);
	$rs=$db->insert("tb_pegawai_lampiran_dokumen",$datain,1);
	if($rs>0) {
		$hasil['status']=1;
		$hasil['pesan']=$rs;
	}
	return json_encode($hasil,true);
}

function hapusdatadokumen($data){
	$db=pDatabase::getInstance();
	$query="delete from tb_pegawai_lampiran_dokumen where id=? ";
	$rs=$db->query($query,array($data['id']));
	return $rs;
}

function getdatalampirandokumen($data){
	$db=pDatabase::getInstance();
	$query="select * from tb_pegawai_lampiran_dokumen where idlampiran=? ";
	$rs=$db->jsonData($query,array($data['idlampiran']));
	return $rs;
}
?>