<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getTabel"=>"getTabel",
		"inputmasterjenissurat"=>"inputmasterjenissurat",
		"editmasterjenissurat"=>"editmasterjenissurat",
		"hapusData"=>"hapusData",
		"setStatus"=>"setStatus",
		"getsubjenissurat"=>"getsubjenissurat",
		"inputdatasub"=>"inputdatasub",
		"updatedatasub"=>"updatedatasub",
		"hapusdatasub"=>"hapusdatasub",
		"edittplsurat"=>"edittplsurat",
		"hapusdatatpl"=>"hapusdatatpl"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("nama");
	$alias=array("Nama Jenis");
	$kolom=array("t1.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$qt="SELECT COUNT(*) as total FROM tb_master_jenissurat as t1
		inner join tb_master_kategorisurat as t2 on t1.idkategori=t2.id
		WHERE t1.idparrent=0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	$query="SELECT t1.`id`,
			t1.`idkategori`,
			t1.idtemplate,
			t1.`kode`,
			t1.kodesurat,
			t1.`nama`,
			t1.`idparrent`,
			t1.`jumlah_sub`,
			t1.`status`,
			t1.lib,
			t1.in_out,
			t2.nama as kategori,
			if(tp1.nama is null,'',tp1.nama) as namatemplate,
			$total as halaman FROM tb_master_jenissurat as t1
		inner join tb_master_kategorisurat as t2 on t1.idkategori=t2.id
		left join tb_master_template_cetak as tp1 on t1.idtemplate=tp1.id
		WHERE t1.idparrent=0 ".$wh."
		ORDER BY t1.id ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	
	return $rs;
}
function inputmasterjenissurat($data){
	$db=pDatabase::getInstance();
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$datain=[
		"id"=>$data['iddata'],
		"idkategori"=>$data['idkategori'],
		"nama"=>$data['nama'],
		"kode"=>$data['kode']."-",
		"kodesurat"=>$data['kodesurat'],
		"lib"=>$data['libsurat'],
		"in_out"=>$data['inout']
	];
	$rs=$db->insert("tb_master_jenissurat",$datain);
	if($rs!=1){
		$statusin=false;
		$dataerr=[["pesan"=>"Gagal input data jenis surat"]];
	}
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$hasil['pesan']=$dataerr;
		$db->rollback();
	}
	
	return json_encode($hasil,true);
}
function editmasterjenissurat($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$query="select * from tb_master_jenissurat where id=? ";
	$rspar=$db->loadAssoc($query,array($data['id']));
	if(!isset($rspar['id'])){
		array_push($dataerr,["pesan"=>"Data tidak ditemukan"]);
		return json_encode($hasil,false);
	}
	
	$db->begin();
	$statusin=true;
	
	$datakode=$data['iddata']."-";
	$datain=[
		"id"=>$data['iddata'],
		"idkategori"=>$data['idkategori'],
		"nama"=>$data['nama'],
		"kode"=>$datakode,
		"kodesurat"=>$data['kodesurat'],
		"lib"=>$data['libsurat'],
		"in_out"=>$data['inout']
	];
	$rs=$db->update("tb_master_jenissurat",$datain,"id",$data['id']);
	if($rs!=1){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal update data !"]);
	}
	
	if($statusin){
		$query="update tb_master_jenissurat set idparrent=? where idparrent=? ";
		$rsu=$db->query($query,array($data['iddata'],$data['id']));
		if($rsu!=1){
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal update data sub parrent!"]);
		}
		
		$carikode=$rspar['kode'];
		$kodesub="$carikode%";
		$query="select * from tb_master_jenissurat where kode like ? and id!=? ";
		$rskd=$db->loadAll($query,array($kodesub,$data['iddata']));
		foreach ($rskd as $obk) {
			$strkode=substr($obk['kode'], strlen($carikode),strlen($obk['kode']));
			$dataupkode=array(
				"kode"=>$datakode.$strkode
			);
			$rsupk=$db->update("tb_master_jenissurat",$dataupkode,"id",$obk['id']);
			if($rsupk!=1){
				$statusin=false;
				array_push($dataerr,["pesan"=>"Gagal update kode sub parrent!"]);
			}
		}
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$hasil['pesan']=$dataerr;
		$db->rollback();
	}
	
	return json_encode($hasil,true);
}

function hapusData($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$query="select * from tb_master_jenissurat where id=? ";
	$rs=$db->loadAssoc($query,array($data['id']));
	if(!isset($rs['id'])){
		array_push($dataerr,["pesan"=>"Data sub jenis surat tidak ditemukan"]);
		return json_encode($hasil,false);
	}
	
	$query="DELETE FROM tb_master_jenissurat WHERE kode like ?";
	$rsd=$db->query($query,array($data['id']));
	if($rsd!=1){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal hapus data jenis surat!"]);
	}
			
	if($statusin){
		$datakode=$rs['kode'];
		$likekode="$datakode%";
		$rsds=$db->query("delete from tb_master_jenissurat where kode like ? ",array($likekode));
		if($rsds!=1){
			array_push($dataerr,["pesan"=>"Gagal hapus data sub"]);
			$statusin=false;
		}
		
	}
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$hasil['pesan']=$dataerr;
		$db->rollback();
	}
	
	return json_encode($hasil,true);
}

function setStatus($data){
	$db=pDatabase::getInstance();
	$datain=[
		"status"=>$data['status']
	];
	$rs=$db->update("tb_master_jenissurat",$datain,"id",$data['id']);
	return $rs;
}

function datacarisub($data=array())
{
	$mode=0;
	$kunci=array("nama");
	$alias=array("Nama Sub Jenis Surat");
	$kolom=array("nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getsubjenissurat($data){
	$db=pDatabase::getInstance();
	$cari="";
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacarisub(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$wh.="and idparrent=? ";
	array_push($datapush,$data['idparrent']);
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	$query="SELECT  SQL_CALC_FOUND_ROWS id,
					`id`,
					idkategori,
					idtemplate,
					kode,
					`nama`,
					`idparrent`,
					`jumlah_sub`,
					`status`
		from tb_master_jenissurat
		where id>0 ".$wh." LIMIT ?,?";
	
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}
	
	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}

function inputdatasub($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$query="select kode from tb_master_jenissurat where id=? ";
	$rsk=$db->loadAssoc($query,array($data['idparrent']));
		
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	$datain=array(
		"id"=>$data['idsub'],
		"idkategori"=>$data['idkategori'],
		"nama"=>$data['namasub'],
		"idparrent"=>$data['idparrent'],
		"kode"=>$data['kode'].$data['idsub']."-"
	);
	
	$rsin=$db->insert("tb_master_jenissurat",$datain);
	if($rsin!=1){
		array_push($dataerr,["pesan"=>"Gagal input data sub jenis surat"]);
		$statusin=false;
	}
	
	if($statusin){
		$query="select count(*) as total from tb_master_jenissurat where idparrent=? ";
		$rst=$db->loadAssoc($query,array($data['idparrent']));
		$totalsub=0;
		if(isset($rst['total'])) $totalsub=$rst['total'];
		
		$dataup=array(
			"jumlah_sub"=>$totalsub
		);
		
		$rsup=$db->update("tb_master_jenissurat",$dataup,"id",$data['idparrent']);
		if($rsup!=1){
			array_push($dataerr,["pesan"=>"Gagal update data parrent"]);
			$statusin=false;
		}
	}
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$hasil['pesan']=$dataerr;
		$db->rollback();
	}
	return json_encode($hasil,false);
}

function updatedatasub($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$query="select * from tb_master_jenissurat where id=? ";
	$rspar=$db->loadAssoc($query,array($data['id']));
	if(!isset($rspar['id'])){
		array_push($dataerr,["pesan"=>"Data tidak ditemukan"]);
		return json_encode($hasil,false);
	}
	
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$datakode=$data['kode'].$data['idsub']."-";
	$datain=array(
		"id"=>$data['idsub'],
		"idkategori"=>$data['idkategori'],
		"nama"=>$data['namasub'],
		"kode"=>$datakode
	);
	
	$rsin=$db->update("tb_master_jenissurat",$datain,"id",$data['id']);
	if($rsin!=1){
		array_push($dataerr,["pesan"=>"Gagal update data sub jenis surat"]);
		$statusin=false;
	}
	
	if($statusin){
		$query="update tb_master_jenissurat set idparrent=? where idparrent=? ";
		$rsu=$db->query($query,array($data['idsub'],$data['id']));
		if($rsu!=1){
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal update data sub parrent!"]);
		}
		
		$carikode=$rspar['kode'];
		$kodesub="$carikode%";
		$query="select * from tb_master_jenissurat where kode like ? and id!=? ";
		$rskd=$db->loadAll($query,array($kodesub,$data['idsub']));
		foreach ($rskd as $obk) {
			$strkode=substr($obk['kode'], strlen($carikode),strlen($obk['kode']));
			$dataupkode=array(
				"kode"=>$datakode.$strkode
			);
			$rsupk=$db->update("tb_master_jenissurat",$dataupkode,"id",$obk['id']);
			if($rsupk!=1){
				$statusin=false;
				array_push($dataerr,["pesan"=>"Gagal update kode sub parrent!"]);
			}
		}
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$hasil['pesan']=$dataerr;
		$db->rollback();
	}
	return json_encode($hasil,false);
}

function hapusdatasub($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$query="select * from tb_master_jenissurat where id=? ";
	$rs=$db->loadAssoc($query,array($data['id']));
	if(!isset($rs['id'])){
		array_push($dataerr,["pesan"=>"Data sub jenis surat tidak ditemukan"]);
		return json_encode($hasil,false);
	}
	
	$db->begin();
	$statusin=true;
	
	$rsd=$db->query("delete from tb_master_jenissurat where id=? ",array($data['id']));
	if($rsd!=1){
		array_push($dataerr,["pesan"=>"Gagal hapus data sub"]);
		$statusin=false;
	}
	$datakode=$rs['kode'];
	$likekode="$datakode%";
	$rsd=$db->query("delete from tb_master_jenissurat where kode like ? ",array($likekode));
	if($rsd!=1){
		array_push($dataerr,["pesan"=>"Gagal hapus data sub"]);
		$statusin=false;
	}
	
	if($statusin){
		$query="select count(*) as total from tb_master_jenissurat where idparrent=? ";
		$rst=$db->loadAssoc($query,array($rs['idparrent']));
		$totalsub=0;
		if(isset($rst['total'])) $totalsub=$rst['total'];
		
		$dataup=array(
			"jumlah_sub"=>$totalsub
		);
		
		$rsup=$db->update("tb_master_jenissurat",$dataup,"id",$rs['idparrent']);
		if($rsup!=1){
			array_push($dataerr,["pesan"=>"Gagal update data parrent"]);
			$statusin=false;
		}
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$hasil['pesan']=$dataerr;
		$db->rollback();
	}
	return json_encode($hasil,false);
}

function edittplsurat($data){
	$db=pDatabase::getInstance();
	$datain=array(
		"idtemplate"=>$data['idtemplate']
	);
	
	$rs=$db->update("tb_master_jenissurat",$datain,"id",$data['idjenissurat']);
	return $rs;
}

function hapusdatatpl($data){
	$db=pDatabase::getInstance();
	$datain=array(
		"idtemplate"=>0
	);
	
	$rs=$db->update("tb_master_jenissurat",$datain,"id",$data['idjenissurat']);
	return $rs;
}
?>