<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
if (!isset($_SESSION)) session_start();
$db=pDatabase::getInstance();
$datafungsi=[
	"getTabel"=>"getTabel",
	"datacari01"=>"datacari01",
	"inputkonten"=>"inputkonten",
	"editkonten"=>"editkonten",
	"hapusData"=>"hapusData",
	"setStatus"=>"setStatus",
	"setUtama"=>"setUtama"
];

if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data,$cl);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("judul","konten","kategori");
	$alias=array("Judul","Isi Konten","Kategori");
	$kolom=array("t1.judul","t1.konten","t2.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.judul LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	if($data['kategori']!=0){
		$wh.="and t1.idkategori=? ";
		array_push($datapush,$data['kategori']);
	}
	$qt="SELECT COUNT(*) as total FROM tb_konten as t1
			inner join tb_konten_kategori as t2 on t1.idkategori=t2.id
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	$query="SELECT t1.`id`,
			t1.`tanggal`,
			t1.`iduser`,
			t1.`idkategori`,
			t1.`judul`,
			t1.`konten`,
			t1.`status`,
			t1.`utama`,
			t1.`dibaca`,
			t1.`idgambar`,
			t2.nama as kategori,
			$total as halaman FROM tb_konten as t1
		inner join tb_konten_kategori as t2 on t1.idkategori=t2.id
		WHERE t1.id>0 ".$wh."
		ORDER BY t1.tanggal desc LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	return $rs;
}

function inputkonten($data){
	$db=pDatabase::getInstance();
	date_default_timezone_set('Asia/Jakarta');
	$tanggal=$db->d_date($data['tanggal'])." ".$data['jam'];
	
	global $config_data;
	$konten=strip_tags($data['keterangan'],$config_data['tag_konten']);
	
	$datain=[
		"tanggal"=>$tanggal,
		"iduser"=>strip_tags($_SESSION['profile']['id']),
		"idkategori"=>$data['idkategori'],
		"judul"=>strip_tags($data['judul']),
		"konten"=>$konten,
		"idgambar"=>$data['idgambar'],
	];
	$rs=$db->insert("tb_konten",$datain,0,1);
	
	return $rs;
}
function editkonten($data){
	$db=pDatabase::getInstance();
	date_default_timezone_set('Asia/Jakarta');
	$sekarang = date("Y-m-d H:i:s");
	$tanggal=$db->d_date($data['tanggal'])." ".$data['jam'];
	
	global $config_data;
	$konten=strip_tags($data['keterangan'],$config_data['tag_konten']);
	
	$datain=[
		"tanggal"=>$tanggal,
		"iduser"=>strip_tags($_SESSION['profile']['id']),
		"idkategori"=>$data['idkategori'],
		"judul"=>strip_tags($data['judul']),
		"konten"=>$konten,
		"idgambar"=>$data['idgambar'],
	];
	$rs=$db->update("tb_konten",$datain,"id",$data['id'],1);
	
	return $rs;
}

function hapusData($data){
	$db=pDatabase::getInstance();
	$query="select idgambar from tb_konten where id=?";
	$rsg=$db->loadAssoc($query,array($data['id']));
	
	$query="DELETE FROM tb_konten WHERE id=? ";
	$rs=$db->query($query,array($data['id']));
	if($rs==1 && isset($rsg['idgambar'])){
		$db->hapusdokumen($rsg['idgambar'],1);
	}
	
	return $rs;
}

function setStatus($data){
	$db=pDatabase::getInstance();
	
	$dataup=[
		"status"=>$data['status']
	];
	$rs=$db->update("tb_konten",$dataup,"id",$data['id']);
	return $rs;
}
function hapusGambar($data){
	$db=pDatabase::getInstance();
	return $db->hapusdokumen($data['id']);
}

function setUtama($data){
	$db=pDatabase::getInstance();
	
	$dataup=[
		"utama"=>$data['status']
	];
	$rs=$db->update("tb_konten",$dataup,"id",$data['id']);
	return $rs;
}

?>