<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getdatapeserta"=>"getdatapeserta",
		"getdokumensurat"=>"getdokumensurat",
		"getTabel"=>"getTabel",
		"inputepengajuanpkl"=>"inputepengajuanpkl",
		"editepengajuanpkl"=>"editepengajuanpkl",
		"hapusData"=>"hapusData",
		"getdataCatatan"=>"getdataCatatan",
		"getcatatansurat"=>"getcatatansurat",
		"getdatakota"=>"getdatakota"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("namasekolah","alamatsekolah");
	$alias=array("Nama Sekolah","Alamat Sekolah");
	$kolom=array("t1.nama_sekolah","t2.alamat_sekolah");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.nama_sekolah LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	if($_SESSION['profile']['level']<=10){
		$wh.="and t1.iduser=? ";
		array_push($datapush,$_SESSION['profile']['id']);
	}
	
	$qt="SELECT COUNT(*) as total FROM tb_pengajuan_pkl as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_jenissurat as t3 on t2.idjenissurat=t3.id
		inner join tb_master_status as a1 on t2.status=a1.id
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	array_unshift($datapush,$_SESSION['profile']['level'],$_SESSION['profile']['level']);
	
	$query="SELECT t1.`id`,
			t1.`tanggal_update`,
			t1.`tanggal_surat`,
			t1.`iduser`,
			t1.`idsurat`,
			t1.`nomor`,
			t1.nomor_surat_pengajuan,
			t1.`nama_sekolah`,
			t1.`alamat_sekolah`,
			t1.`jumlah_peserta`,
			t1.`jumlah_dokumen`,
			t1.`keterangan`,
			t1.`status_balasan`,
			t2.`status`,
			t2.statusdisposisi,
			t2.nomor_panjang as nomorsurat,
			t2.jumlah_catatan,
			t3.lib,
			t3.nama as jenissurat,
			a1.nama as namastatus,
			a1.bg,a1.warna,
			if(b1.id is null,0,1) as edit,
			if(b2.id is null,0,1) as hapus,
			$total as halaman FROM tb_pengajuan_pkl as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_jenissurat as t3 on t2.idjenissurat=t3.id
		inner join tb_master_status as a1 on t2.status=a1.id
		left join tb_master_status_level as b1 on t2.status=b1.idstatus and b1.mode=0 and b1.idlevel=?
		left join tb_master_status_level as b2 on t2.status=b2.idstatus and b2.mode=1 and b2.idlevel=?
		WHERE t1.id>0 ".$wh."
		ORDER BY t1.tanggal_surat ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	
	return $rs;
}

function getdatapeserta($data){
	$db=pDatabase::getInstance();
	date_default_timezone_set('Asia/Jakarta');
	
	$wh="";
	$datapush=array($data['idsuratpkl']);
	
	if($_SESSION['profile']['level']<=10){
		$wh.="and t2.iduser=? ";
		array_push($datapush,$_SESSION['profile']['id']);
	}
	
	$query="select t1.`id`,
			t1.`idsuratpkl`,
			t1.`nama`,
			t1.`nopelajar`,
			t1.`alamat` 
		from tb_pengajuan_pkl_peserta as t1
		inner join tb_pengajuan_pkl as t2 on t1.idsuratpkl=t2.id
		where t1.idsuratpkl=? ".$wh;
	$rs=$db->jsonData($query,$datapush);
	return $rs;
}

function getdokumensurat($data){
	$db=pDatabase::getInstance();
	$query="SELECT  
				t1.nama,
				t1.iddokumen
			FROM tb_pengajuan_pkl_dokumen as t1
		inner join tb_dokumen as t2 on t1.iddokumen=t2.id
		where t1.idsuratpkl=? ";
	$rs=$db->jsonData($query,array($data['idsuratpkl']));
	return $rs;
}

function inputepengajuanpkl($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$statuspengajuan=60;
	if($data['submitdata']==1) $statuspengajuan=61;
	
	$idkategorisurat=2;
	$idjenissurat=20;
	
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$sekarang=date("Y-m-d");
	$tahun=date('Y',strtotime($sekarang));
	$bulan=date('m',strtotime($sekarang));
	
	$nomorsurat=1;
	$nomorsuratpanjang="";
	
	$datanomor=$db->buatnomorsurat($idjenissurat,$sekarang);
	if(isset($datanomor['nomor'])) $nomorsurat=$datanomor['nomor'];
	if(isset($datanomor['nomorpanjang'])) $nomorsuratpanjang=$datanomor['nomorpanjang'];
	
	$datapeserta=$data['datapeserta'];
	
	$datajs=array(
		"nomor"=>$nomorsuratpanjang,
		"nomor_surat_pengajuan"=>$data['nomorsuratpengajuan'],
		"nama_sekolah"=>$data['namasekolah'],
		"idpropinsi"=>$data['idpropinsi'],
		"propinsi"=>$data['idpropinsi'],
		"idkota"=>$data['idkota'],
		"kota"=>$data['kota'],
		"alamat_sekolah"=>$data['alamatsekolah'],
		"keterangan"=>$data['keterangan'],
		"datapeserta"=>$datapeserta
	);
	
	$datasr=array(
		"tanggal_surat"=>$sekarang,
		"nomor"=>$nomorsurat,
		"idpegawai"=>0,
		"iduser"=>$_SESSION['profile']['id'],
		"idkategori"=>$idkategorisurat,
		"idjenissurat"=>$idjenissurat,
		"nomor_panjang"=>$nomorsuratpanjang,
		"tahun"=>$tahun,
		"bulan"=>$bulan,
		"datasurat"=>json_encode($datajs,true),
		"status"=>$statuspengajuan
	);
	
	$rss=$db->insert("tb_suratbdk",$datasr,1);
	if($rss<=0){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal input data surat"]);
	}
	
	$idsurat=$rss;
	$iddisposisi=0;
	if($data['submitdata']==1){
		$datahasil=$db->setdatadisposisiawal($idsurat);
		if(isset($datahasil['status'])){
			if($datahasil['status']!=1) {
				$statusin=false;
				array_push($dataerr,["pesan"=>"Gagal set disposisi surat"]);
			}
		}
	}
	
	if($statusin){
		$datain=[
			"tanggal_surat"=>$sekarang,
			"idsurat"=>$idsurat,
			"iduser"=>$_SESSION['profile']['id'],
			"nomor"=>$nomorsuratpanjang,
			"nomor_surat_pengajuan"=>$data['nomorsuratpengajuan'],
			"nama_sekolah"=>$data['namasekolah'],
			"idpropinsi"=>$data['idpropinsi'],
			"idkota"=>$data['idkota'],
			"alamat_sekolah"=>$data['alamatsekolah'],
			"keterangan"=>$data['keterangan'],
			"status"=>$statuspengajuan
		];
		$rs=$db->insert("tb_pengajuan_pkl",$datain,1);
		if($rs<=0) {
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal input data pengajuan PKL"]);
		}
		
		$idsuratpkl=$rs;
		foreach ($datapeserta as $obs) {
			$datainps=array(
				"idsuratpkl"=>$idsuratpkl,
				"nama"=>$obs['nama'],
				"nopelajar"=>$obs['nopelajar'],
				"alamat"=>$obs['alamat']
			);
			
			$rsps=$db->insert("tb_pengajuan_pkl_peserta",$datainps);
			if($rsps!=1){
				$statusin=false;
				array_push($dataerr,["pesan"=>"Gagal input data peserta pengajuan pkl"]);
			}
		}
		
		$datadokumen=$data['datadokumen'];
		if(sizeof($datadokumen)>0 && $statusin==true){
			foreach ($datadokumen as $obdok) {
				$dataindokpkl=array(
					"idsuratpkl"=>$idsuratpkl,
					"iddokumen"=>$obdok['iddokumen'],
					"nama"=>$obdok['nama']
				);
				
				$rsindokpkl=$db->insert("tb_pengajuan_pkl_dokumen",$dataindokpkl);
				if($rsindokpkl!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data dokumen pengajuan pkl"]);
				}
				
				$dataindoksurat=array(
					"idsurat"=>$idsurat,
					"iddokumen"=>$obdok['iddokumen'],
					"nama"=>$obdok['nama']
				);
				
				$rsindoksurat=$db->insert("tb_suratbdk_dokumen",$dataindoksurat);
				if($rsindoksurat!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data dokumen surat "]);
				}
			}
		}
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function editepengajuanpkl($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$wh="";
	$datapush=array($_SESSION['profile']['level'],$data['id']);
	if($_SESSION['profile']['level']<=10){
		$wh.="and t1.iduser=? ";
		array_push($datapush,$_SESSION['profile']['id']);
	}
	
	$query="select t1.id,
			t1.idsurat,
			t2.status,
			t2.tanggal_surat,
			t2.nomor,
			t2.nomor_panjang
			from tb_pengajuan_pkl as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_status_level as t3 on t2.status=t3.idstatus
		where t3.mode=0 and t3.idlevel=? and t1.id=? ".$wh;
	$rsc=$db->loadAssoc($query,$datapush);
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$nomorsuratpanjang=$rsc['nomor_panjang'];
	$nomorsurat=$rsc['nomor'];
	$statuspengajuan=$rsc['status'];
	if($data['submitdata']==1) $statuspengajuan=61;
	
	$idkategorisurat=2;
	$idjenissurat=20;
	$idsurat=$rsc['idsurat'];
	
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$datapeserta=$data['datapeserta'];
	
	$datajs=array(
		"nomor"=>$nomorsuratpanjang,
		"nomor_surat_pengajuan"=>$data['nomorsuratpengajuan'],
		"nama_sekolah"=>$data['namasekolah'],
		"idpropinsi"=>$data['idpropinsi'],
		"propinsi"=>$data['idpropinsi'],
		"idkota"=>$data['idkota'],
		"kota"=>$data['kota'],
		"alamat_sekolah"=>$data['alamatsekolah'],
		"keterangan"=>$data['keterangan'],
		"datapeserta"=>$datapeserta
	);
	
	$datasr=array(
		"iduser"=>$_SESSION['profile']['id'],
		"datasurat"=>json_encode($datajs,true),
		"nomor"=>$nomorsurat,
		"nomor_panjang"=>$nomorsuratpanjang,
		"status"=>$statuspengajuan
	);
	

	$rss=$db->update("tb_suratbdk",$datasr,"id",$idsurat);
	if($rss!=1){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal update data surat"]);
	}
	
	$iddisposisi=0;
	if($data['submitdata']==1){
		$datahasil=$db->setdatadisposisiawal($idsurat);
		if(isset($datahasil['status'])){
			if($datahasil['status']!=1) {
				$statusin=false;
				array_push($dataerr,["pesan"=>"Gagal set disposisi surat"]);
			}
		}
	}
	
	if($statusin){
		$datain=[
			"idsurat"=>$idsurat,
			"iduser"=>$_SESSION['profile']['id'],
			"nomor"=>$nomorsuratpanjang,
			"nomor_surat_pengajuan"=>$data['nomorsuratpengajuan'],
			"nama_sekolah"=>$data['namasekolah'],
			"idpropinsi"=>$data['idpropinsi'],
			"idkota"=>$data['idkota'],
			"alamat_sekolah"=>$data['alamatsekolah'],
			"keterangan"=>$data['keterangan'],
			"status"=>$statuspengajuan
		];
		$rs=$db->update("tb_pengajuan_pkl",$datain,"id",$data['id']);
		if($rs!=1) {
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal update data pengajuan pkl"]);
		}
		
		$idsuratpkl=$data['id'];
		$query="delete from tb_pengajuan_pkl_peserta where idsuratpkl=? ";
		$rsdel=$db->query($query,array($idsuratpkl));
		if($rsdel!=1){
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal re update data peserta pkl"]);
		}
		
		foreach ($datapeserta as $obs) {
			$datainps=array(
				"idsuratpkl"=>$idsuratpkl,
				"nama"=>$obs['nama'],
				"nopelajar"=>$obs['nopelajar'],
				"alamat"=>$obs['alamat']
			);
			
			$rsps=$db->insert("tb_pengajuan_pkl_peserta",$datainps);
			if($rsps!=1){
				$statusin=false;
				array_push($dataerr,["pesan"=>"Gagal input data peserta pengajuan pkl"]);
			}
		}
		
		$query="delete from tb_suratbdk_dokumen where idsurat=? ";
		$rsdelsr=$db->query($query,array($idsurat));
		if($rsdelsr!=1){
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal re update data dokumen surat"]);
		}
		
		$query="delete from tb_pengajuan_pkl_dokumen where idsuratpkl=? ";
		$rsdelsrpk=$db->query($query,array($idsuratpkl));
		if($rsdelsrpk!=1){
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal re update data dokumen surat pkl"]);
		}
		
		$datadokumen=$data['datadokumen'];
		if(sizeof($datadokumen)>0 && $statusin==true){
			foreach ($datadokumen as $obdok) {
				$dataindokpkl=array(
					"idsuratpkl"=>$idsuratpkl,
					"iddokumen"=>$obdok['iddokumen'],
					"nama"=>$obdok['nama']
				);
				
				$rsindokpkl=$db->insert("tb_pengajuan_pkl_dokumen",$dataindokpkl);
				if($rsindokpkl!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data dokumen pengajuan pkl"]);
				}
				
				$dataindoksurat=array(
					"idsurat"=>$idsurat,
					"iddokumen"=>$obdok['iddokumen'],
					"nama"=>$obdok['nama']
				);
				
				$rsindoksurat=$db->insert("tb_suratbdk_dokumen",$dataindoksurat);
				if($rsindoksurat!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data dokumen surat "]);
				}
			}
		}
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function hapusData($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$wh="";
	$datapush=array($_SESSION['profile']['level'],$data['id']);
	if($_SESSION['profile']['pegawai']==1){
		$wh.="and t1.idpegawai=? ";
		array_push($datapush,$_SESSION['profile']['idpegawai']);
	}
	
	$query="select t1.id,t1.idsurat from tb_pengajuan_pkl as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_status_level as t3 on t2.status=t3.idstatus
		where t3.mode=1 and t3.idlevel=? and t1.id=? ".$wh;
	$rsc=$db->loadAssoc($query,$datapush);
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$query="DELETE FROM tb_suratbdk WHERE id=? ";
	$rs=$db->query($query,array($rsc['idsurat']));
	
	$hasil['status']=$rs;
	if($rs==1){
		$hasil['pesan']="Berhasil";
	}
	return json_encode($hasil,true);
}

function datacarictt($data=array())
{
	$mode=0;
	$kunci=array("jenis");
	$alias=array("Jenis Surat");
	$kolom=array("t4.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getdataCatatan($data){
	$db=pDatabase::getInstance();
	$cari="";
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t4.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacarictt(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$wh.="and t1.idsurat=? ";
	array_push($datapush,$data['idsurat']);
	
	if($_SESSION['profile']['pegawai']==1){
		$wh.="and t3.idpegawai=? ";
		array_push($datapush,$_SESSION['profile']['idpegawai']);
	}
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	$query="select SQL_CALC_FOUND_ROWS t1.id,
				t1.`id`,
				t1.`tanggal`,
				t1.`iduser`,
				t1.`idpegawai`,
				t1.`idsurat`,
				t1.`catatan`,
				if(t2.nama is null,'',t2.nama) as namapegawai
			from tb_suratbdk_catatan as t1
			left join tb_pegawai as t2 on t1.idpegawai=t2.id
			inner join tb_suratbdk as t3 on t1.idsurat=t3.id
			inner join tb_master_jenissurat as t4 on t3.idjenissurat=t4.id
			where t1.id>0 ".$wh."
			order by t1.tanggal asc limit ?,?";
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}
	
	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}

function getcatatansurat($data){
	$db=pDatabase::getInstance();
	$query="select 
				t1.`id`,
				t1.`tanggal`,
				t1.`iduser`,
				t1.`idpegawai`,
				t1.`idsurat`,
				t1.`catatan`,
				if(t2.nama is null,'',t2.nama) as namapegawai
			from tb_suratbdk_catatan as t1
			left join tb_pegawai as t2 on t1.idpegawai=t2.id
			inner join tb_suratbdk as t3 on t1.idsurat=t3.id
			inner join tb_master_jenissurat as t4 on t3.idjenissurat=t4.id
			where t1.id>0 and t1.idsurat=?
			order by t1.tanggal asc";
	$rs=$db->jsonData($query,array($data['idsurat']));
	return $rs;
}

function getdatakota($data){
	$db=pDatabase::getInstance();
	$query="select * from tb_kota where idpropinsi=? ";
	$rs=$db->jsonData($query,array($data['idpropinsi']));
	return $rs;
}
?>