<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getmasakerja"=>"getmasakerja",
		"getTabel"=>"getTabel",
		"inputepengajuancuti"=>"inputepengajuancuti",
		"editepengajuancuti"=>"editepengajuancuti",
		"hapusData"=>"hapusData",
		"getdataCatatan"=>"getdataCatatan",
		"getcatatansurat"=>"getcatatansurat"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("nama");
	$alias=array("Nama Pegawai");
	$kolom=array("t2.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t2.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	if($_SESSION['profile']['pegawai']==1){
		$wh.="and t1.idpegawai=? ";
		array_push($datapush,$_SESSION['profile']['idpegawai']);
	}
	
	$qt="SELECT COUNT(*) as total FROM tb_cuti_pegawai as t1
		inner join tb_pegawai as t2 on t1.idpegawai=t2.id
		inner join tb_master_jeniscuti as t3 on t1.idjeniscuti=t3.id
		inner join tb_kodewaktu as t4 on t1.idkodewaktu=t4.id
		inner join tb_suratbdk as t5 on t1.idsurat=t5.id
		inner join tb_master_status as a1 on t5.status=a1.id
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	array_unshift($datapush,$_SESSION['profile']['level'],$_SESSION['profile']['level']);
	
	$query="SELECT t1.`id`,
			t1.`tanggal_input`,
			t1.`tanggal_surat`,
			t1.`idsurat`,
			t1.`idpegawai`,
			t1.`idjeniscuti`,
			t1.`waktu`,
			t1.`idkodewaktu`,
			t1.`keterangan`,
			t1.`jumlah_catatan`,
			t5.`status`,
			t5.statusdisposisi,
			t2.nama as namapegawai,
			t2.nip,
			t3.nama as jeniscuti,
			t4.nama as kodewaktu,
			t5.jumlah_catatan,
			t5.nomor_panjang as nomorsurat,
			t6.lib,
			t6.nama as jenissurat,
			a1.nama as namastatus,
			a1.bg,a1.warna,
			if(b1.id is null,0,1) as edit,
			if(b2.id is null,0,1) as hapus,
			$total as halaman FROM tb_cuti_pegawai as t1
		inner join tb_pegawai as t2 on t1.idpegawai=t2.id
		inner join tb_master_jeniscuti as t3 on t1.idjeniscuti=t3.id
		inner join tb_kodewaktu as t4 on t1.idkodewaktu=t4.id
		inner join tb_suratbdk as t5 on t1.idsurat=t5.id
		inner join tb_master_jenissurat as t6 on t5.idjenissurat=t6.id
		inner join tb_master_status as a1 on t5.status=a1.id
		left join tb_master_status_level as b1 on t5.status=b1.idstatus and b1.mode=0 and b1.idlevel=?
		left join tb_master_status_level as b2 on t5.status=b2.idstatus and b2.mode=1 and b2.idlevel=?
		WHERE t1.id>0 ".$wh."
		ORDER BY t1.tanggal_surat ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	
	return $rs;
}

function getmasakerja($data){
	$db=pDatabase::getInstance();
	date_default_timezone_set('Asia/Jakarta');
	
	$wh="";
	$datapush=array($data['idpegawai']);
	
	if($_SESSION['profile']['pegawai']==1){
		$wh.="and id=? ";
		array_push($datapush,$_SESSION['profile']['idpegawai']);
	}
	
	$hasil=array(
		"tahun"=>0,
		"bulan"=>0,
		"hari"=>0
	);
	$query="select * from tb_pegawai where id=? ".$wh;
	$rs=$db->loadAssoc($query,$datapush);
	if(isset($rs['id'])){
		$datetime1 = new DateTime($rs['tanggal_sk_awal']);
		$datetime2 = new DateTime();
		$interval = $datetime1->diff($datetime2);
		
		$hasil['tahun']=$interval->y;
		$hasil['bulan']=$interval->m;
		$hasil['hari']=$interval->d;
	}
	
	return json_encode($hasil,true);
}

function inputepengajuancuti($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$statuspengajuan=20;
	if($data['submitdata']==1) $statuspengajuan=21;
	
	$idpegawai=$data['idpegawai'];
	if($_SESSION['profile']['pegawai']==1) $idpegawai=$_SESSION['profile']['idpegawai'];
	
	$idkategorisurat=1;
	$idjenissurat=10;
	
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$sekarang=date("Y-m-d");
	$tahun=date('Y',strtotime($sekarang));
	$bulan=date('m',strtotime($sekarang));
	
	$nomorsurat=1;
	$nomorsuratpanjang="";
	
	$datanomor=$db->buatnomorsurat($idjenissurat,$sekarang);
	if(isset($datanomor['nomor'])) $nomorsurat=$datanomor['nomor'];
	if(isset($datanomor['nomorpanjang'])) $nomorsuratpanjang=$datanomor['nomorpanjang'];
	
	$datajs=array(
		"idpegawai"=>$idpegawai,
		"idjeniscuti"=>$data['idjeniscuti'],
		"waktu"=>$data['waktu'],
		"idkodewaktu"=>$data['kodewaktu'],
		"keperluan"=>$data['keperluan'],
		"alamatcuti"=>$data['alamatcuti'],
		"telpcuti"=>$data['telpcuti'],
	);
	$datasr=array(
		"tanggal_surat"=>$sekarang,
		"nomor"=>$nomorsurat,
		"idpegawai"=>$idpegawai,
		"iduser"=>$_SESSION['profile']['id'],
		"idkategori"=>$idkategorisurat,
		"idjenissurat"=>$idjenissurat,
		"nomor_panjang"=>$nomorsuratpanjang,
		"tahun"=>$tahun,
		"bulan"=>$bulan,
		"datasurat"=>json_encode($datajs,true),
		"status"=>$statuspengajuan
	);
	
	$rss=$db->insert("tb_suratbdk",$datasr,1);
	if($rss<=0){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal input data surat"]);
	}
	
	$idsurat=$rss;
	$iddisposisi=0;
	if($data['submitdata']==1){
		$datahasil=$db->setdatadisposisiawal($idsurat);
		if(isset($datahasil['status'])){
			if($datahasil['status']!=1) {
				$statusin=false;
				array_push($dataerr,["pesan"=>"Gagal set disposisi surat"]);
			}
		}
	}
	
	if($statusin){
		$datamasakerja=$db->getmasakerja($idpegawai);
		$masakerja=0;
		if(isset($datamasakerja['tahun'])) $masakerja=$datamasakerja['tahun'];
		$tanggalmulai=$db->d_date($data['tanggalmulai']);
		$tanggalselesai=$db->d_date($data['tanggalselesai']);
		
		$datain=[
			"tanggal_surat"=>$sekarang,
			"idsurat"=>$idsurat,
			"iduser"=>$_SESSION['profile']['id'],
			"idpegawai"=>$idpegawai,
			"idjeniscuti"=>$data['idjeniscuti'],
			"waktu"=>$data['waktu'],
			"idkodewaktu"=>$data['kodewaktu'],
			"tanggal_mulai"=>$tanggalmulai,
			"tanggal_selesai"=>$tanggalselesai,
			"keperluan"=>$data['keperluan'],
			"alamat_cuti"=>$data['alamatcuti'],
			"telp_cuti"=>$data['telpcuti'],
			"masa_kerja"=>$masakerja,
			"status"=>$statuspengajuan
		];
		$rs=$db->insert("tb_cuti_pegawai",$datain);
		if($rs!=1) {
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal input data pengajuan cuti"]);
		}
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function editepengajuancuti($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$wh="";
	$datapush=array($_SESSION['profile']['level'],$data['id']);
	if($_SESSION['profile']['pegawai']==1){
		$wh.="and t1.idpegawai=? ";
		array_push($datapush,$_SESSION['profile']['idpegawai']);
	}
	
	$query="select t1.id,t1.idsurat,
			t1.status,
			t2.tanggal_surat,
			t2.nomor,
			t2.nomor_panjang
			from tb_cuti_pegawai as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_status_level as t3 on t2.status=t3.idstatus
		where t3.mode=0 and t3.idlevel=? and t1.id=? ".$wh;
	$rsc=$db->loadAssoc($query,$datapush);
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$statuspengajuan=$rsc['status'];
	if($data['submitdata']==1) $statuspengajuan=21;
	
	$idpegawai=$data['idpegawai'];
	if($_SESSION['profile']['pegawai']==1) $idpegawai=$_SESSION['profile']['idpegawai'];
	
	$idkategorisurat=1;
	$idjenissurat=10;
	$idsurat=$rsc['idsurat'];
	
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$sekarang=strtotime($rsc['tanggal_surat']);
	$nomorsurat=1;
	$nomorsuratpanjang="";
	
	$datanomor=$db->buatnomorsurat($idjenissurat,$sekarang);
	if(isset($datanomor['nomor'])) $nomorsurat=$datanomor['nomor'];
	if(isset($datanomor['nomorpanjang'])) $nomorsuratpanjang=$datanomor['nomorpanjang'];
	
	$datajs=array(
		"idpegawai"=>$idpegawai,
		"idjeniscuti"=>$data['idjeniscuti'],
		"waktu"=>$data['waktu'],
		"idkodewaktu"=>$data['kodewaktu'],
		"keperluan"=>$data['keperluan'],
		"alamatcuti"=>$data['alamatcuti'],
		"telpcuti"=>$data['telpcuti'],
	);
	
	$datasr=array(
		"idpegawai"=>$idpegawai,
		"iduser"=>$_SESSION['profile']['id'],
		"datasurat"=>json_encode($datajs,true),
		"status"=>$statuspengajuan
	);
	if($data['submitdata']==1 && $rsc['status']==20){
		$datasr['nomor']=$nomorsurat;
		$datasr['nomor_panjang']=$nomorsuratpanjang;
	}

	$rss=$db->update("tb_suratbdk",$datasr,"id",$idsurat);
	if($rss!=1){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal update data surat"]);
	}
	
	$iddisposisi=0;
	if($data['submitdata']==1){
		$datahasil=$db->setdatadisposisiawal($idsurat);
		if(isset($datahasil['status'])){
			if($datahasil['status']!=1) {
				$statusin=false;
				array_push($dataerr,["pesan"=>"Gagal set disposisi surat"]);
			}
		}
	}
	
	if($statusin){
		$datamasakerja=$db->getmasakerja($idpegawai);
		$masakerja=0;
		if(isset($datamasakerja['tahun'])) $masakerja=$datamasakerja['tahun'];
		$tanggalmulai=$db->d_date($data['tanggalmulai']);
		$tanggalselesai=$db->d_date($data['tanggalselesai']);
		
		$datain=[
			"idsurat"=>$idsurat,
			"idpegawai"=>$idpegawai,
			"idjeniscuti"=>$data['idjeniscuti'],
			"waktu"=>$data['waktu'],
			"idkodewaktu"=>$data['kodewaktu'],
			"tanggal_mulai"=>$tanggalmulai,
			"tanggal_selesai"=>$tanggalselesai,
			"keperluan"=>$data['keperluan'],
			"alamat_cuti"=>$data['alamatcuti'],
			"telp_cuti"=>$data['telpcuti'],
			"masa_kerja"=>$masakerja,
			"status"=>$statuspengajuan
		];
		$rs=$db->update("tb_cuti_pegawai",$datain,"id",$data['id']);
		if($rs!=1) {
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal update data pengajuan cuti"]);
		}
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function hapusData($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$wh="";
	$datapush=array($_SESSION['profile']['level'],$data['id']);
	if($_SESSION['profile']['pegawai']==1){
		$wh.="and t1.idpegawai=? ";
		array_push($datapush,$_SESSION['profile']['idpegawai']);
	}
	
	$query="select t1.id,t1.idsurat from tb_cuti_pegawai as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_status_level as t3 on t2.status=t3.idstatus
		where t3.mode=1 and t3.idlevel=? and t1.id=? ".$wh;
	$rsc=$db->loadAssoc($query,$datapush);
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$query="DELETE FROM tb_suratbdk WHERE id=? ";
	$rs=$db->query($query,array($rsc['idsurat']));
	
	$hasil['status']=$rs;
	if($rs==1){
		$hasil['pesan']="Berhasil";
	}
	return json_encode($hasil,true);
}

function datacarictt($data=array())
{
	$mode=0;
	$kunci=array("jenis");
	$alias=array("Jenis Surat");
	$kolom=array("t4.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getdataCatatan($data){
	$db=pDatabase::getInstance();
	$cari="";
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t4.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacarictt(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$wh.="and t1.idsurat=? ";
	array_push($datapush,$data['idsurat']);
	
	if($_SESSION['profile']['pegawai']==1){
		$wh.="and t3.idpegawai=? ";
		array_push($datapush,$_SESSION['profile']['idpegawai']);
	}
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	$query="select SQL_CALC_FOUND_ROWS t1.id,
				t1.`id`,
				t1.`tanggal`,
				t1.`iduser`,
				t1.`idpegawai`,
				t1.`idsurat`,
				t1.`catatan`,
				if(t2.nama is null,'',t2.nama) as namapegawai
			from tb_suratbdk_catatan as t1
			left join tb_pegawai as t2 on t1.idpegawai=t2.id
			inner join tb_suratbdk as t3 on t1.idsurat=t3.id
			inner join tb_master_jenissurat as t4 on t3.idjenissurat=t4.id
			where t1.id>0 ".$wh."
			order by t1.tanggal asc limit ?,?";
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}
	
	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}

function getcatatansurat($data){
	$db=pDatabase::getInstance();
	$query="select 
				t1.`id`,
				t1.`tanggal`,
				t1.`iduser`,
				t1.`idpegawai`,
				t1.`idsurat`,
				t1.`catatan`,
				if(t2.nama is null,'',t2.nama) as namapegawai
			from tb_suratbdk_catatan as t1
			left join tb_pegawai as t2 on t1.idpegawai=t2.id
			inner join tb_suratbdk as t3 on t1.idsurat=t3.id
			inner join tb_master_jenissurat as t4 on t3.idjenissurat=t4.id
			where t1.id>0 and t1.idsurat=?
			order by t1.tanggal asc";
	$rs=$db->jsonData($query,array($data['idsurat']));
	return $rs;
}
?>